#ifndef GenerateDialog_included
#define GenerateDialog_included

#include <qchkbox.h>
#include <qdialog.h>
#include <qstring.h>
#include <qlabel.h>
#include <qgrpbox.h>
#include <qlined.h>

class GenerateDialog : public QDialog
{
    Q_OBJECT
    
public:

    GenerateDialog
    (
	const QString&	fileName,
	const QString&	dlgClassName,
	const QString&	classHeader,
	const QString&	classSource,
	const QString&	dataHeader,
	const QString&	dataSource,
	QWidget*	parent = NULL,
	const char*	name = NULL
    );

    bool GenerateSource( QString &, QString & );
    bool GenerateData( QString &, QString & );

private slots: // Methods
    void GetSourceNames( bool );
    void GetDataNames( bool );

    void EndDialog();
    
private: // Attributes
    QCheckBox	itsSourceCheckbox;
    QGroupBox itsSourceGB;
    QLabel    itsClassHeaderLabel, itsClassSourceLabel;
    QLineEdit itsClassHeaderEdit, itsClassSourceEdit;

    QCheckBox	itsDataCheckbox;
    QGroupBox itsDataGB;
    QLabel    itsDataHeaderLabel, itsDataSourceLabel;
    QLineEdit itsDataHeaderEdit, itsDataSourceEdit;
    
    QString itsClassHeader, itsClassSource;
    // Names for the source files

    QString itsDataHeader, itsDataSource;
    // Names for the data files
};

#endif // GenerateDialog_included
