#ifndef FontSelectDialog_included
#define FontSelectDialog_included

#include <qfont.h>
#include <qwidget.h>

#include "FontSelectDialogData.h"

class FontSelectDialog : public FontSelectDialogData
{
    Q_OBJECT

public:

    FontSelectDialog
    (
	const QFont&	font,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~FontSelectDialog();

    QFont GetFont() const;
    // get the selected font

private slots:

    void FamilyChanged( const char*	family );
    void PointSizeChanged( const char*	size );
    void WeightChanged( const char*	weight );
    void StyleHintChanged( const char*	hint );
    void CharSetChanged( const char*	set );
    
    void ItalicToggled( bool		clicked );
    void UnderlinedToggled( bool	clicked );
    void StrikeoutToggled( bool		clicked );
    void FixedPitchToggled( bool	clicked );
    
};


inline QFont FontSelectDialog::GetFont() const
{
    return itsSampleText->font();
}

#endif // FontSelectDialog_included
