#include "widget/DlgUser.h"

#include "prop/UserPage.h"

#define Inherited DlgWidget

int DlgUser::itsNextWidgetNum = 1;

DlgUser::DlgUser
(
    QWidget*		parent,
    const char*	name
 )
    :
    Inherited( DlgWidget::DW_User, parent )
{
    itsWidget = new Label( parent, 	
			   CreateName( "User", name, itsNextWidgetNum ) );
    itsWidget->setFrameStyle( QFrame::WinPanel | QFrame::Sunken );
    itsWidget->setAlignment( AlignCenter );

    itsWidget->setMinimumSize( 10, 10 );
}

DlgUser::~DlgUser()
{
    // itsWidget destroyed when its parent is destroyed
}


void DlgUser::GetPropertyPages
(
    QWidget*		parent,
    QList<QWidget>&	pages,
    QStrList&		labels
)
{
    pages.append( new UserPage( this, parent, "User Widget" ) );

    labels.append( "User Widget" );
}


void DlgUser::SaveContents
(
    QTextStream&	stream
)
{
    stream << "\nUser {";
  
    stream << "\n\t\tUserClassHeader {" << itsUserClassHeader << "}";
    stream << "\n\t\tUserClassName {" << itsUserClassName << "}";

    //DlgUser::SaveQt( stream, (const QLabel *) itsWidget );

    DlgWidget::SaveContents( stream );

    stream << "\n}";
}

void DlgUser::SaveQt
(
    QTextStream & ,//stream,
    const QLabel* //widget
)
{
}

bool DlgUser::RestoreKeyValue( QString &key, QString &value )
{
  bool retVal = TRUE;

  if( key == "Name" )
  {
      // Update the widget number so that no duplicate names are created
      UpdateNextWidgetNumber( value, itsNextWidgetNum );
  }

  if( key == "UserClassHeader" )
  {
      itsUserClassHeader = value;
  } 
  else if( key == "UserClassName" )
  {
      itsUserClassName = value;
      itsWidget->setText( value );
  }
  else
  {
      // At last DlgWidget catch the rest
      retVal = DlgWidget::RestoreKeyValue( key, value );
  }

  return retVal;
}

bool DlgUser::RestoreQt
(
    const QString& ,//key,
    const QString& ,//value,
    QLabel* //widget
)
{
    // Key unknown
    return FALSE;
}  


void DlgUser::GenSrc
(
    DlgWidget&			dlgWidget,
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    DlgWidget::GenSrc( dlgWidget, stream, varName, zOrdering );
}


QString DlgUser::GetHeaderFilename() const
{
    return "\"" + itsUserClassHeader + "\"";
}







