#include "widget/LineEdit.h"

#define Inherited QLineEdit

LineEdit::LineEdit
(
    QWidget*		widget,
    const char*		name
)
    :
    Inherited( widget, name )
{
}


void LineEdit::mousePressEvent
(
    QMouseEvent*	event
)
{
    emit MousePress( this, event );	
    //Inherited::mousePressEvent( event );
    
}


void LineEdit::mouseDoubleClickEvent( QMouseEvent*	event )
{
    emit MouseDoubleClick( this, event );
}


void LineEdit::mouseMoveEvent
(
    QMouseEvent*	event
)
{
    emit MouseMove( this, event );
    //Inherited::mouseMoveEvent( event );
    
}


void LineEdit::mouseReleaseEvent
(
    QMouseEvent*	 //event
)
{
    emit MouseRelease();
    //Inherited::mouseReleaseEvent( event );
    
}


void LineEdit::paintEvent
(
    QPaintEvent*	event
)
{
    Inherited::paintEvent( event );
    
    emit Paint( this );
}


void LineEdit::resizeEvent
(
    QResizeEvent*	event
)
{
    Inherited::resizeEvent( event );
    
    emit Resize( this, event );
}


void LineEdit::moveEvent
(
    QMoveEvent*	event
)
{
    Inherited::moveEvent( event );
    
    emit Move( this, event );
}





