#include <toad/toad.hh>
#include <toad/buttonbase.hh>

class TFatCheckButton:
	public TButtonBase, public TBoolManipulator
{
	public:
		TFatCheckButton(TWindow*, const string&);

		template <class T>
		TFatCheckButton(TWindow *p, const string &t, T *d):
			TButtonBase(p, t)
		{
			_Init();
			SetData(d);
		}
		
		void mouseLDown(int,int,unsigned);
		void keyDown(TKey, char*, unsigned);
		void paint();
		
		TSignal sigValueChanged;
	protected:
		void _Init();
};

TFatCheckButton::TFatCheckButton(TWindow *p, const string &t):
	TButtonBase(p, t)
{
	_Init();
}

void TFatCheckButton::_Init()
{
	_data = false;
}

void TFatCheckButton::mouseLDown(int, int, unsigned)
{
	if (!Enabled())
		return;
	
	_data = !_data;
	
	if (_data)
		SetBackground(TColor::SLIDER_FACE);
	else
		SetBackground(TColor::BTNFACE);
	
	SetFocus();
	Invalidate();
	ValueChanged();
	sigValueChanged();
}

void TFatCheckButton::keyDown(TKey key, char* str, unsigned modifier)
{
	if (!modifier && (key==TK_RETURN || *str==' '))
		mouseLDown(0,0,0);
}

void TFatCheckButton::paint()
{
	TPen pen(this);
	DrawShadow(pen, _data);
	DrawText(pen, Label(), _data);
}

class TMyWindow: public TWindow
{
	public:
		TMyWindow(TWindow* p, const string& t):TWindow(p,t) {
			TFatCheckButton *cb = new TFatCheckButton(this, "Edit Mode");
			cb->SetShape(10,10,100,25);
			
		}
};

int ToadMain()
{
	return TMyWindow(NULL,"fatcheckbutton").Run();
}

