/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/listbox.hh>
#include <toad/combobox.hh>
#include <toad/checkbox.hh>
#include <toad/pushbutton.hh>
#include <toad/textfield.hh>
#include <toad/io/resourcefile.hh>

class TMainWindow: public TDialog
{
	public:
		TMainWindow(TWindow *, const string &);
		~TMainWindow();
};

int ToadMain()
{
	// open the resource file with the dialogs layout information
	//-----------------------------------------------------------
	new TResourceFile(TOADBase::ExecutablePath()+"data.res");
  return TMainWindow(NULL, "New Filedialog").Run();
}

TMainWindow::TMainWindow(TWindow *p, const string &t)
	:TDialog(p,t)
{
	static const char *files[] = {
		".",
		"..",
		"bin",
		"usr",
		NULL
	};
	new TTextField(this, "filename");
	new TListBox(this, "directories", files);
	new TListBox(this, "files", files);
	new TComboBox(this, "filetype", files);
	new TCheckBox(this, "hidden");
	new TPushButton(this, "Ok");
	new TPushButton(this, "Reload");
	new TPushButton(this, "Cancel");

	DoLayout("TMainWindow");
}

TMainWindow::~TMainWindow()
{
	TWindow *wnd = FirstChild();
	cout << "size:" << Width() << "," << Height() << endl;
	while(wnd) {
		TRect r;
		wnd->GetShape(&r);
		cout<< "\"" << wnd->Title() << "\": "
				<< r.x << "," << r.y << "," << r.w << "," << r.h << endl;
		wnd = NextSibling(wnd);
	}
}