/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for X-Windows
 * Copyright (C) 1996-98 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This program creates the tables for the special char lexical analyzer
 * of the THTMLView class.
 */


#include <cstdio>
#include <cstring>
#include <vector>

#define START 156
#define FILENAME "lex_special_char.cc"

// This is a list of all character entity references for ISO 8859-1 characters
char *names[]=
{
	"quot", "amp", "lt", "gt",
	"nbsp","iexcl","cent","pound","curren","yen","brvbar","sect","uml","copy",
	"ordf","laquo","not","shy","reg","macr","deg","plusmn","sup2","sup3","acute",
	"micro","para","middot","cedil","sup1","ordm","raquo","frac14","frac12",
	"frac34","iquest","Agrave","Aacute","Acirc","Atilde","Auml","Aring","AElig",
	"Ccedil","Egrave","Eacute","Ecirc","Euml","Igrave","Iacute","Icirc","Iuml",
	"ETH","Ntilde","Ograve","Oacute","Ocirc","Otilde","Ouml","times","Oslash",
	"Ugrave","Uacute","Ucirc","Uuml","Yacute","THORN","szlig","agrave","aacute",
	"acirc","atilde","auml","aring","aelig","ccedil","egrave","eacute","ecirc",
	"euml","igrave","iacute","icirc","iuml","eth","ntilde","ograve","oacute",
	"ocirc","otilde","ouml","divide","oslash","ugrave","uacute","ucirc","uuml",
	"yacute","thorn","yuml",NULL
};

unsigned short len[256-START];

struct TTable
{
	unsigned short t[256];
	TTable()
	{
		memset(t,0,256);
	}
};

vector<TTable> table;
TTable empty_table;

int main()
{
	unsigned short i,j;
	
	// fr jeden Namen bestimmen, wieviele Zeichen von ihm ausgewertet
	// werden mssen, um ihn von den anderen unterscheiden zu knnen
	//-----------------------------------------------------------------
	printf("1st stage\n");
	unsigned short l1,l2,l;
	unsigned short k;
	for(i=0;i<256-START;i++)
	{
		// printf("current name is %i: %s\n",i,names[i]);
		len[i]=0;
		l1=strlen(names[i]);
		for(j=0; j<256-START; j++)
		{
			if (j==i)
				continue;
			l2=strlen(names[j]);
			l=min(l1,l2);
			for(k=0;k<l;k++)
			{
				if (names[i][k]!=names[j][k])
					break;
			}
			len[i]=max(len[i],k);
		}
//		char m = names[i][len[i]];
//		names[i][len[i]]=0;
//		printf("nr=%i, len=%i: %s\n",i,len[i],names[i]);
//		names[i][len[i]]=m;
	}

	// die Tabellen fr den Baum zum Suchen der Namen erstellen
	//----------------------------------------------------------
	printf("2nd stage\n");
	unsigned short table_counter=1;
	table.push_back(empty_table);
	for(i=0;i<256-START;i++)
	{
//		printf("current name is %i: %s\n",i,names[i]);
		unsigned short current_table=0;
		for(j=0; j<len[i]/*strlen(names[i])*/; j++)
		{
			if (table[current_table].t[names[i][j]]==0)
			{
//				printf("new table %i for %i. char %c\n",table_counter,j,names[i][j]);
				table.push_back(empty_table);
				table[current_table].t[names[i][j]]=table_counter;
				current_table = table_counter;
				table_counter++;
			}
			else
			{
				current_table = table[current_table].t[names[i][j]];
//				printf("old table %i for %i. char %c\n",current_table,j,names[i][j]);
			}
		}
		table[current_table].t[names[i][j]]=i+START;
	};
	printf("created %i tables\n",table_counter);
	
	// Programmdatei erstellen
	//----------------------------------------------------------
	FILE *out = fopen(FILENAME, "w");
	fprintf(out,"// created automatically by:"__FILE__" on "__DATE__"\n\n");
	fprintf(out,"static const unsigned char table[%i][%i] = \n{\n",
		table_counter,1+'z'-'A');
	for(i=0; i<table_counter; i++)
	{
		fprintf(out,"\t{");
		for(j='A'; j<='z'; j++)
		{
			fprintf(out,"%i",table[i].t[j]);
			if (j!='z')
				fprintf(out,",");
		}
		if (i!=table_counter-1)
			fprintf(out,"},\n");
		else
			fprintf(out,"}\n");
	}
	fprintf(out,"};\n");

	vector<char*> rest_strings;
	l=2;
	fprintf(out,"\nstatic const char rest_pointer[%i] = {\n\t",256-START);
	for(i=0; i<256-START; i++)
	{
		for(j=0; j<rest_strings.size(); j++)
		{
			if (strcmp(names[i]+len[i]+1, rest_strings[j])==0)
				break;
		}
		if (j==rest_strings.size())
		{
			fprintf(out,"%i",rest_strings.size());
			rest_strings.push_back(names[i]+len[i]+1);
		}
		else
		{
			fprintf(out,"%i",j);
		}
		if (i!=256-START-1)
			fprintf(out,",");
		
		l+=3;
		if (l>80)
		{
			l=2+3;
			fprintf(out,"\n\t");
		}
	}
	fprintf(out,"\n};\n");
	
	fprintf(out,"\nstatic const char *rest_strings[%i] = {",rest_strings.size());
	l=80;
	for(i=0; i<rest_strings.size(); i++)
	{
		l+=strlen(rest_strings[i])+3;
		if (l>80)
		{
			l=2+strlen(rest_strings[i])+3;
			fprintf(out,"\n\t");
		}
		fprintf(out,"\"%s\"",rest_strings[i]);
		if (i!=rest_strings.size()-1)
			fprintf(out,",");
	}

	fprintf(out,"};\n");
	fclose(out);
}
