/*
 * TPaint -- a simple bitmap editor
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <typeinfo>
#include <string>

#include <cstdio>
#include <cstring>
#include <unistd.h>

#include <toad/toad.hh>
#include <toad/dialog.hh>
#include <toad/pushbutton.hh>
#include <toad/fatradiobutton.hh>
#include <toad/form.hh>
#include <toad/scrollbar.hh>
#include <toad/menubar.hh>
#include <toad/textfield.hh>
#include <toad/radiobutton.hh>
#include <toad/checkbox.hh>
#include <toad/mdiwindow.hh>
#include <toad/combobox.hh>
#include <toad/filedialog.hh>
#include <toad/dialogeditor.hh>

class TBitmapEditor;
class TTool;

TBitmapEditor *bme;				// current bitmap
TColor color[1];					// current color
TTool *tool = NULL;				// current tool

void RegisterBitmapEditor(TBitmapEditor *ed)
{
	bme = ed;
}

void RemoveBitmapEditor(TBitmapEditor*)
{
	bme = NULL;
}

#include "MainWindow.hh"
#include "NewBitmapDialog.hh"
#include "ZoomDlg.hh"
#include "BitmapEditor.hh"
#include "Tool.hh"
#include "ColorEditor.hh"
#include "Palette.hh"
#include "ToolBar.hh"

/***************************************************************************
                                  ToadMain
 ***************************************************************************/
void CreateMemoryFiles();

int ToadMain()
{
try{
	CreateMemoryFiles();
	if (TDialogEditor::running)
		TOADBase::SetResourcePrefix("file://resource/");
	else
		TOADBase::SetResourcePrefix("memory://resource/");
	tool = new TDrawTool();
	TMainWindow(NULL,"TPaint").Run();
	delete tool;
}
catch(exception &e) {
	cout << e.what() << endl;
}
	return 0;
}

/***************************************************************************
                                 TMainWindow
 ***************************************************************************/
TMainWindow::TMainWindow(TWindow *p,const string &t)
	:TForm(p,t)
{
}

static TBitmap *bmpTPaint;


void TMainWindow::create()
{
	bKeepOwnBorder=true;
	SetSize(640,480);

	// set icon for main window
	//--------------------------
	bmpTPaint = new TBitmap;
	bmpTPaint->Load("memory://tpaint.png");
	SetIcon(bmpTPaint);

	// create MDI window with 4 children 
	//-----------------------------------
	ca=new TMDIWindow(this, "Test");

		(new TToolBar(ca,"TToolBar"))
			->SetPosition(390,5);
		(new TPalette(ca,"TPalette"))
			->SetPosition(400,70);
		(new TColorEditor(ca,"TColorEditor"))
			->SetPosition(380,140);

	// configure TMenuBar
	//--------------------
	TMenuBar *mb=new TMenuBar(this);

	TMenuCheck *mc;
	TMenuItem *mi;

  mb->BgnPulldown("File");
    mi = mb->AddItem("New");
    OLD_CONNECT(this,menuNew, mi,mi->sigActivate);
    mi = mb->AddItem("Open..");
    OLD_CONNECT(this,menuOpen, mi,mi->sigActivate);
    mi = mb->AddItem("Save As..");
    OLD_CONNECT(this,menuSaveAs, mi,mi->sigActivate);
    mi = mb->AddItem("Quit");
    OLD_CONNECT(this,menuQuit, mi,mi->sigActivate);
  mb->EndPulldown();

  mb->BgnPulldown("Options");
    mi = mb->AddItem("Zoom");
    OLD_CONNECT(this,menuZoom, mi,mi->sigActivate);
  mb->EndPulldown();

  mb->BgnPulldown("Windows");
		mc = mb->AddCheck("Toolbar",0);
		OLD_CONNECT(this,toolbar, mc,mc->sigActivate);
  	mb->AddCheck("Palette", 0);
  	mb->AddCheck("ColorEditor", 0);
  	mb->BgnPulldown("More");
  		mb->AddItem("Red");
  		mb->AddItem("Green");
  		mb->AddItem("Blue");
  	mb->EndPulldown();
  mb->EndPulldown();
  mb->BgnPulldown("Help");
    mi = mb->AddItem("Info");
    OLD_CONNECT(this, menuInfo, mi,mi->sigActivate);
    mi = mb->AddItem("Copyright");
    OLD_CONNECT(this, menuCopyright, mi,mi->sigActivate);
    mi = mb->AddItem("Help");
    OLD_CONNECT(this, menuHelp, mi,mi->sigActivate);
  mb->EndPulldown();

	//+-----------------+
	//| configure TForm |
	//+-----------------+
	Attach(mb, SIDE_TOP | SIDE_LEFT | SIDE_RIGHT, ATTACH_FORM);

	Attach(ca, SIDE_TOP, ATTACH_WINDOW, mb);
	Attach(ca, SIDE_LEFT | SIDE_RIGHT | SIDE_BOTTOM, ATTACH_FORM);
}

void TMainWindow::menuNew()
{
	TNewBitmapDialog(this,"TPaint: New", ca).DoModal();
}

void TMainWindow::menuOpen()
{
	TFileDialog dlg(this,"TPaint: Open..");
	TAlterBitmap::GetInputFilter(dlg);
	dlg.DoModal();
	if (dlg.GetResult()==IDOK) {
		TBitmapEditor *bme = new TBitmapEditor(ca, dlg.GetFilename());
		if (bme->Load(dlg.GetFilename().c_str() )) {
			bme->Create();
		}	else {
			delete bme;
		}
	}
}

void TMainWindow::menuSaveAs()
{
	if (bme) {
		TFileDialog dlg(this,"TPaint: Save As..");
		TAlterBitmap::GetOutputFilter(dlg);
		dlg.SetFilename(bme->Title());
		dlg.DoModal();
		if (dlg.GetResult()==IDOK) {
			try {
				bme->Save(dlg.GetFilename().c_str(), dlg.GetXtra());
				bme->SetTitle(dlg.GetFilename());
			}
			catch(exception &e) {
				MessageBox(this, "Failed to save", e.what(), MB_OK | MB_ICONSTOP);
			}
		}
	}	else {
		MessageBox(this,"TPaint: Save As..",
			"No active bitmap editor window.",
			MB_OK | MB_ICONEXCLAMATION);
	}
}

void TMainWindow::menuZoom()
{
  if (bme)
    TZoomDlg(this,"TPaint: change zoom", bme).DoModal();
  else
    MessageBox(this, "TPaint: change zoom", "No active bitmap editor.",
    MB_ICONINFORMATION | MB_OK );
}

void TMainWindow::menuInfo()
{
 	MessageBox(this, "TPaint: Info",
		"TPaint v0.2 Alpha\n"
 		"Copyright  1996,97 by Mark-Andr Hopf\n\n"
		"This program is part of the TOAD GUI Toolkit, see:\n"
 		"www: http://www.informatik.uni-rostock.de/~hopf/toad/\n"
 		"for further information or write to:\n"
 		"eMail: hopf@informatik.uni-rostock.de"
 		, MB_OK, bmpTPaint);
}

void TMainWindow::menuCopyright()
{
 	MessageBox(this, "TPaint: Copyright",
 		"TPaint v0.2 Alpha\n"
 		"Copyright  1996,97 by Mark-Andr Hopf\n\n"
 		"This program is free software; you can redistribute it and/or modify "
 		"it under the terms of the GNU General Public License as published by "
 		"the Free Software Foundation; either version 2 of the License, or "
 		"(at your option) any later version.\n\n"
 		"This program is distributed in the hope that it will be useful, "
 		"but WITHOUT ANY WARRANTY; without even the implied warranty of "
 		"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the "
 		"GNU General Public License for more details.\n\n"
 		"You should have received a copy of the GNU General Public License "
 		"along with this program; if not, write to the Free Software "
 		"Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA."
 		, MB_OK, bmpTPaint);
}

void TMainWindow::menuHelp()
{
	MessageBox(this, "TPaint: Help",
		"Use the middle mouse button for draging and droping "
		"the colours around.\n\n"
		"More help will be provided in the future when the "
		"THyperView class is done."
		, MB_ICONINFORMATION | MB_OK);
}

void TMainWindow::menuQuit()
{
	PostQuitMessage(0);
}

void TMainWindow::toolbar()
{
	printf("void MainWindow::toolbar\n");
}

/***************************************************************************
                                  TToolBar
 ***************************************************************************/
TToolBar::TToolBar(TWindow *p,const string &t)
	:super(p,t)
{
	SetBackground(TColor::DIALOG);
	bFocusManager = true;
	SetSize(120,40);
	TFatRadioButton *btn;
	
	btn=new TFatRadioButton(this, "Plot", 100, ID_PLOT);
		OLD_CONNECT(this,button, btn,btn->sigActivate);
		btn->SetShape(0,0,40,40);
		btn->LoadBitmap("memory://tpaint_plot.png");
		btn->SetToolTip("draw points");

	btn=new TFatRadioButton(this, "Draw", 100, ID_DRAW);
    OLD_CONNECT(this,button, btn,btn->sigActivate);
		btn->SetShape(40,0,40,40);
		btn->LoadBitmap("memory://tpaint_draw.png");
		btn->SetToolTip("draw lines");

	btn=new TFatRadioButton(this, "Fill", 100, ID_FILL);
    OLD_CONNECT(this,button, btn,btn->sigActivate);
		btn->SetShape(80,0,40,40);
		btn->LoadBitmap("memory://tpaint_fill.png");
		btn->SetToolTip("fill a region");
}

void TToolBar::button(TRadioButtonBase *btn)
{
	if (::tool)	delete ::tool;			// remove old tool
	
	switch(btn->Value())								// install new tool
	{
		case ID_PLOT:
			::tool = new TPlotTool();
			break;
		case ID_DRAW:
			::tool = new TDrawTool();
			break;
		case ID_FILL:
			::tool = new TFillTool();
			break;
	}
}
