#include <toad/toad.hh>
#include <toad/pushbutton.hh>

class TMyWindow: public TWindow
{
  public:
    TMyWindow(TWindow *parent, const string &title):TWindow(parent,title){};
  protected:
    void create();
    void actButton();
};

void TMyWindow::create()
{
  TPushButton *btn = new TPushButton(this, "Hit me !");
  btn->SetShape(5,5,120,22);
  CONNECT(btn->sigActivate, this,actButton);
}

void TMyWindow::actButton()
{
  MessageBox(this, Title() + " Dialog", "Ouch...", MB_OK | MB_ICONHAND);
}

int ToadMain()
{
  return TMyWindow(NULL, "3rd program").Run();
}
