/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TComboBox
#define TComboBox TComboBox

#include <toad/listbox.hh>

class TLBAdapter;
class TListBox;

class TComboBox: public TControl
{
		typedef TControl super;

	public:
		TComboBox(TWindow *parent, const string &title, TLBAdapter *lba);
		
		template <class T>
		TComboBox(TWindow *p, const string &t, T data)
			:super(p, t), lb(this, _lb_title, NewListBoxAdapter(data)) {
			_Init();
		}

		template <class T>
		TComboBox(TWindow *p, const string &t, T data, ulong n)
			:super(p, t), lb(this, _lb_title, NewListBoxAdapter(data, n)) {
			_Init();
		}
		
		void _Init();
		void SetAdapter(TLBAdapter*);
		
		GSignal1P<unsigned> sigSelect;
		
		void SetSelection(unsigned);
		unsigned GetFirstSelectedItem();
		
	protected:
		void paint();
		void resize();
		void keyDown(TKey,char*,unsigned);
		void closeRequest();
		
	private:
		static const char *_lb_title;
		TListBox lb;
		class TComboButton;
		TComboButton *btn;

		void buttonDown();
		void actSelect(unsigned);
};
#endif
