/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TDialog
#define TDialog TDialog

#include <toad/gadgetwindow.hh>

class TInObjectStream;
class TOutObjectStream;

typedef GSmartPointer<TDialog> PDialog;

class TDialog: 
	public TGadgetWindow
{
		typedef TGadgetWindow super;
	public:
		TDialog(TWindow *parent, const string &title);
		~TDialog();
		
		void SetCenterMode(EWindowPlacement p) {
			_placement = p;
		}
		
		void DoLayout(const string &s);

		void DoModal();
		void DoModeless();

		void Apply();
		void Reset();
		void Ok();			// Apply + closeRequest

		bool bDrawFocus;
		
		void adjust();
		void paint();
		void childNotify(TWindow*, EChildNotify);
		void closeRequest();

	protected:
		EWindowPlacement _placement;

		string _resource_name;
		void Store(TOutObjectStream&);
		void Restore(TInObjectStream&);
		void Arrange();
};

#endif
