/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toad.hh>
#include <toad/dialogeditor.hh>

PDialogEditor TDialogEditor::active_editor;
TWindow* TDialogEditor::edit_window = NULL;
TWindow* TDialogEditor::ctrl_window = NULL;

bool TDialogEditor::running = false;
bool TDialogEditor::enabled = false;

//! TDialogEditor
//. The base class for a dialog editor implementation. You won't need this
//. class until you want to implement your own TOAD dialog editor.

TDialogEditor::TDialogEditor()
{
}

TDialogEditor::~TDialogEditor()
{
}

void TDialogEditor::SetEditWindow(TWindow *w)
{ 
	if (w!=edit_window) {
		TWindow* o = edit_window;
		edit_window = w;
		active_editor->windowChanged(o, w);
	}
}
