/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/gadget.hh>
#include <toad/gadgeteditor.hh>

int TGText::cx;

void 
TGText::CalcSize()
{
	int w=0, h=0;
	unsigned l,r;
	l = 0;
	while(true) {
		h+=TOADBase::DefaultFont().Height();
		r = text.find('\n', l);
		int wl = TOADBase::DefaultFont().TextWidth(text.substr(l,r==string::npos ? r : r-l));
		if (wl>w)
			w=wl;
		if (r==string::npos)
			break;
		l = r+1;
	}
	p2.x=p1.x+w+1;
	p2.y=p1.y+h+1;
}

void 
TGText::paint(TPen &pen, EPaintType type)
{
	pen.SetFont(&TOADBase::DefaultFont());
	pen.SetLineColor(line_color);
	unsigned l,r;
	int yp = p1.y;
	l = 0;
	while(true) {
		r = text.find('\n', l);
		pen.DrawString(p1.x,yp, text.substr(l,r==string::npos ? r : r-l));
		if (type==EDIT && l<=cx && cx<=r) {
			unsigned dx = pen.TextWidth(text.substr(l, cx-l));
			pen.DrawLine(p1.x+dx,yp,p1.x+dx,yp+pen.Height());
		}
		if (r==string::npos)
			break;
		l = r+1;
		yp+=pen.Height();
	}
}

double 
TGText::distance(int mx, int my)
{
	if (TRectangle(p1, p2).IsInside(mx, my))
		return INSIDE;
	return super::distance(mx,my);
}

bool
TGText::getHandle(unsigned,TPoint&)
{
	return false;
}

bool 
TGText::startInPlace()
{
	cx = 0;
	return true;
}

void 
TGText::startCreate()
{
	cx = 0;
}

unsigned 
TGText::stop(TGadgetEditor*)
{
	if (text.empty())
		return STOP|DELETE;
	return STOP;
}

unsigned 
TGText::keyDown(TGadgetEditor *editor, TKey key, char*, unsigned)
{
	editor->InvalidateFigure(this);
	switch(key) {
		case TK_LEFT:
			if (cx>0)
				cx--;
			break;
		case TK_RIGHT:
			if (cx<text.size())
				cx++;
			break;
		case TK_UP:
			break;
		case TK_DOWN:
			break;
		case TK_HOME:
			if (cx==0 || text[cx-1]=='\n')
				break;
			cx = text.rfind('\n', cx-1);
			if (cx==string::npos)
				cx=0;
			else
				cx++;
			break;
		case TK_END:
			cx = text.find('\n', cx);
			if (cx==string::npos)
				cx=text.size();
			break;
		case TK_BACKSPACE:
			if (cx>0)
				cx--;
			else
				break;
		case TK_DELETE:
			text.erase(cx,1);
			break;
		case TK_RETURN:
			text.insert(cx, 1, '\n');
			cx++;
			break;
		default:
			if (key>=32 && key<=255) {
				text.insert(cx, 1, key);
				cx++;
			}
	}
	CalcSize();
	editor->InvalidateFigure(this);
	return CONTINUE;
}

unsigned 
TGText::mouseLDown(TGadgetEditor *editor, int x, int y, unsigned)
{
	switch(editor->state) {
		case TGadgetEditor::STATE_START_CREATE:
			cx = 0;
			p1.x = x;
			p1.y = y;
			CalcSize();
			editor->InvalidateFigure(this);
			startInPlace();
			break;
			
		case TGadgetEditor::STATE_CREATE:
		case TGadgetEditor::STATE_EDIT:
			if (distance(x,y)>RANGE) {
				editor->InvalidateFigure(this);
				if (text.empty())
					return STOP|DELETE|REPEAT;
				return STOP|REPEAT;
			}
			break;
			
		default:
			break;
	}
	return CONTINUE;
}

unsigned
TGText::mouseMove(TGadgetEditor*, int x, int y, unsigned)
{
	return CONTINUE;
}

unsigned 
TGText::mouseLUp(TGadgetEditor*, int, int, unsigned)
{
	return CONTINUE;
}

void 
TGText::store(TOutObjectStream &file, ulong version)
{
	super::store(file, version);
	file.WriteWord(text.size());
	file.WriteString(text.c_str(), text.size());
}

void 
TGText::restore(TInObjectStream &file, ulong version)
{
	super::restore(file, version);
	unsigned l = file.ReadWord();
	char buffer[l+1];
	file.ReadString(buffer,l);
	buffer[l]=0;
	text = buffer;
}
