/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef TListBox
#define TListBox TListBox

#include <toad/toad.hh>
#include <toad/control.hh>
#include <toad/pointer.hh>

#include <vector>

class TVScrollBar;
class THScrollBar;

// #define OLD_LISTBOX

class TLBAdapter: 
	public TOADBase, public TSmartObject
{
	public:
		virtual ~TLBAdapter(){};
		virtual unsigned ItemHeight()=0;
		virtual unsigned ItemCount()=0;
		virtual unsigned ItemMaxWidth(){return 0;}
		virtual void mouseLDown(int,int,unsigned,unsigned,int,int){};
		virtual void PrintItem(int x,int y,unsigned item,TPen &)=0;
		virtual string GetItemAsString(unsigned){return "";}
};

typedef GSmartPointer<TLBAdapter> PLBAdapter;

TLBAdapter* NewListBoxAdapter(const vector<string> *data);
TLBAdapter* NewListBoxAdapter(const char **data,ulong);
TLBAdapter* NewListBoxAdapter(const char **data);

class TListBox: 
	public TControl, private TStringManipulator
{
		typedef TControl super;
		typedef vector<bool> TFlag;
		
	public:
		TListBox(TWindow *p, const string &t, TLBAdapter *lba);

		template <class T>
		TListBox(TWindow *p, const string &t, T data)
			:super(p, t) {
			_Init();
			SetAdapter(NewListBoxAdapter(data));
		}

		template <class T>
		TListBox(TWindow *p, const string &t, T data, ulong n)
			:super(p, t) {
			_Init();
			SetAdapter(NewListBoxAdapter(data, n));
		}
		~TListBox();
		
		template <class T>
		void SetData(T data) {
			SetAdapter(NewListBoxAdapter(data));
		}

		template <class T>
		void SetData(T data, ulong n) {
			SetAdapter(NewListBoxAdapter(data, n));
		}
		
		GSignal1P<unsigned> sigSelect;
		TSignal sigDoubleClick;
		
		unsigned GetItemCount() const;
		unsigned GetSelectedItemCount() const;
		unsigned GetTopItemPosition() const;
		unsigned SetTopItemPosition(unsigned);
		TLBAdapter* GetAdapter();
		void SetAdapter(TLBAdapter*);
		unsigned GetFirstSelectedItem();
		unsigned GetNextSelectedItem();

		void Select(unsigned);
		void Deselect(unsigned);
		void DeselectAll();
		bool IsSelected(unsigned) const;

		enum EType {SINGLE, MULTIPLE};
		void SetType(EType);
		EType Type() { return _type; }
		
		void AdapterChanged();
		
		void destroy();
		void resize();
		void paint();
		void mouseLDown(int,int,unsigned);
		void keyDown(TKey, char*, unsigned);

		bool _faked_focus;	// used by TComboBox
		static const unsigned npos = (unsigned)-1;
	private:
		void _Init();
		void Center();
	
		class THScrollBar *hscroll;
		class TVScrollBar *vscroll;
		void adjust_sb();
		
		PLBAdapter _adapter;
		EType _type;

		unsigned pos;			// first visible item
		unsigned visible;
		unsigned yo;
		
		unsigned _cy;			// caret position
		
		unsigned _single;	// selected item
		TFlag _multiple;	// bit vector of selected items
		
		void cmdVValueChanged(TVScrollBar*);
		void scrollDown();
		void scrollUp();
		void cmdHScroll();
};

#endif
