/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#include <toad/toadbase.hh>
#include <toad/pen.hh>
#include <toad/window.hh>
#include <toad/buttonbase.hh>
#include <toad/pushbutton.hh>

/*---------------------------------------------------------------------------*
 | mouseLDown                                                                |
 *---------------------------------------------------------------------------*/
void TPushButton::mouseLDown(int,int,unsigned)
{
	if (!Enabled() || !sigActivate.IsConnected())
		return;
		
  bDown=true;
  if (IsFocus()) {
		UpdateWindow(true);
  } else {
    if (!SetFocus())	// 'SetFocus' calls 'focus', which already updates the window
			UpdateWindow(true);
  }
  sigArm();
}

/*---------------------------------------------------------------------------*
 | mouseLUp                                                                  |
 *---------------------------------------------------------------------------*/
void TPushButton::mouseLUp(int,int,unsigned)
{
  if (bDown) {
    bDown=false;
    if (bInside) {
      UpdateWindow(true);
      sigDisarm();
      sigActivate();
    }
  }
}

/*---------------------------------------------------------------------------*
 | keyDown                                                                   |
 *---------------------------------------------------------------------------*/
void TPushButton::keyDown(TKey key, char* str, unsigned modifier)
{
	if (!Enabled() || !sigActivate.IsConnected())
		return;

  if (!bDown && modifier==0 && (key==TK_RETURN || *str==' ')) {
  	sigArm();
  	sigDisarm();
  	sigActivate();
  }
}

/*---------------------------------------------------------------------------*
 | mouseEnter		                                                             |
 *---------------------------------------------------------------------------*/
void TPushButton::mouseEnter(int,int,unsigned)
{
	bInside = true;
	if(bDown)	{
		UpdateWindow(true);
		sigArm();
	}
}

/*---------------------------------------------------------------------------*
 | mouseLeave		                                                             |
 *---------------------------------------------------------------------------*/
void TPushButton::mouseLeave(int,int,unsigned)
{
	bInside = false;
	if(bDown)	{
		UpdateWindow(true);
		sigDisarm();
	}
}

/*---------------------------------------------------------------------------*
 | paint		                                                                 |
 *---------------------------------------------------------------------------*/
void TPushButton::paint()
{
	TPen pen(this);
	DrawShadow(pen, bDown && bInside);
	DrawText(pen, Label(), bDown && bInside, sigActivate.IsConnected());
}
