/*
 * TOAD -- A Simple and Powerful C++ GUI Toolkit for the X Window System
 * Copyright (C) 1996-99 by Mark-Andr Hopf
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,   
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public 
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
 * MA  02111-1307,  USA
 */

#ifndef __TOAD_TYPES_HH
#define __TOAD_TYPES_HH

typedef unsigned long ulong;
typedef unsigned char ubyte;

typedef unsigned char byte;

#include <vector>

struct TPoint {
	TPoint() {x=y=0;}
	TPoint(int a, int b):x(a),y(b){}
  int x,y;
  void Set(int a,int b) {	x=a;y=b; }
};

struct TDPoint {
	TDPoint() {x=y=0;}
	TDPoint(double a, double b):x(a),y(b){}
  double x,y;
  void Set(double a,double b) {	x=a;y=b; }
};

struct TRectangle {
	int x,y,w,h;
	TRectangle(){Set(0,0,0,0);};
	TRectangle(int x,int y,int w,int h){Set(x,y,w,h);}
	TRectangle(const TPoint &p1, const TPoint &p2){Set(p1,p2);}
	void Set(int a,int b,int c,int d);
	void Set(const TPoint&, const TPoint&);
	void operator =(const TRectangle &r){x=r.x;y=r.y;w=r.w;h=r.h;}
	void operator =(const TRectangle *r){x=r->x;y=r->y;w=r->w;h=r->h;}
	bool IsInside(int px,int py) const {
		return (x<=px && px<x+w && y<=py && py<y+h);
	}
};

#define TRect TRectangle

class TPolygon: 
	public vector<TPoint>
{
	public:
		void AddPoint(const TPoint &p) { push_back(p); }
		void AddPoint(int x, int y) { push_back(TPoint(x,y)); }
		bool IsInside(int x, int y) const;
};

class TDPolygon: 
	public vector<TDPoint>
{
	public:
		void AddPoint(const TDPoint &p) { push_back(p); }
		void AddPoint(double x, double y) { push_back(TDPoint(x,y)); }
};

#endif
