/******************************************************************************
 JOutPipeStream.h

	Interface for the JOutPipeStream class

	Copyright  1998 by John Lindal. All rights reserved.

 *****************************************************************************/

#ifndef _H_JOutPipeStream
#define _H_JOutPipeStream

#include <stdiostream.h>
#include <jTypes.h>

class JOutPipeStream : public ostream
{
public:

	JOutPipeStream(const int fd, const JBoolean close);

	virtual ~JOutPipeStream();

	void	close();

	JBoolean	WillClosePipe() const;
	void		ShouldClosePipe(const JBoolean close = kTrue);

private:

	stdiobuf	itsBuffer;
	const int	itsDescriptor;
	JBoolean	itsCloseFlag;	// kTrue => close when we are destructed

private:

	// not allowed

	JOutPipeStream(const JOutPipeStream& source);
	const JOutPipeStream& operator=(const JOutPipeStream& source);
};


/******************************************************************************
 Closing the underlying pipe

 *****************************************************************************/

inline JBoolean
JOutPipeStream::WillClosePipe()
	const
{
	return itsCloseFlag;
}

inline void
JOutPipeStream::ShouldClosePipe
	(
	const JBoolean close
	)
{
	itsCloseFlag = close;
}

#endif
