/******************************************************************************
 JPrefsFile.h

	Interface for the JPrefsFile class

	Copyright  1995 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JPrefsFile
#define _H_JPrefsFile

#include <JFileArray.h>

typedef JFAID	JPrefID;

class JString;

class JPrefsFile : public JFileArray
{
public:

	virtual ~JPrefsFile();

	void	GetData(const JPrefID& id, JStaticBuffer* data) const;

	void	SetData(const JPrefID& id, ostrstream& data);
	void	SetData(const JPrefID& id, const JCharacter* data);

	void	RemoveData(const JPrefID& id);

protected:

	JPrefsFile(const JString& fileName);

private:

	// not allowed

	JPrefsFile(const JPrefsFile& source);
	JPrefsFile& operator=(const JPrefsFile& source);
};


/******************************************************************************
 GetData

 ******************************************************************************/

inline void
JPrefsFile::GetData
	(
	const JPrefID&	id,
	JStaticBuffer*	data
	)
	const
{
	GetElement(id, data);
}

/******************************************************************************
 RemoveData

 ******************************************************************************/

inline void
JPrefsFile::RemoveData
	(
	const JPrefID& id
	)
{
	RemoveElement(id);
}

#endif
