/******************************************************************************
 JSimpleProcess.h

	Interface for the JSimpleProcess class

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JSimpleProcess
#define _H_JSimpleProcess

#include <JProcess.h>
#include <ace/LSOCK_Stream.h>
#include <ace/UNIX_Addr.h>
#include <JMessageProtocol.h>	// template; requires ace includes

class JSimpleProcess : public JProcess
{
public:

	static void	Create(const JCharacter* str, const JBoolean detach);
	static void	Create(const JCharacter* argv[], const JSize count,
					   const JBoolean detach);

	static JError	Create(JSimpleProcess** process, const JCharacter* str,
						   const JBoolean deleteWhenFinished = kFalse);

	static JError	Create(JSimpleProcess** process,
						   const JCharacter* argv[], const JSize count,
						   const JBoolean deleteWhenFinished = kFalse);

	JSimpleProcess(const pid_t pid, const int fd,
				   const JBoolean deleteWhenFinished);

	virtual ~JSimpleProcess();

protected:

	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	typedef JMessageProtocol<ACE_LSOCK_STREAM>	ProcessLink;

private:

	ProcessLink*	itsLink;			// keeps pipe from filling up and blocking
	JBoolean		itsAutoDeleteFlag;	// kTrue => delete when process is finished

private:

	void	ReportError();

	// not allowed

	JSimpleProcess(const JSimpleProcess& source);
	const JSimpleProcess& operator=(const JSimpleProcess& source);
};

#endif
