/******************************************************************************
 JStaticBuffer.cc

							The Static Buffer Class

	This class encapsulates a char[] as a static memory buffer.

	*** We assume that whatever data we are passed was allocated with new[]
	*** The data must also be null terminated.  (This shouldn't be a problem
		as long as the data comes from an ostrstream.)

	In order to construct istrstreams from StaticBuffers, we have to be
	able to convert to char*.  This makes us unsafe because somebody could
	delete our data behind our back.  If used carefully, however, we are
	useful because the user never has to call new and delete on the buffer if
	the JStaticBuffer object is on the stack.

	This class was not designed to be a base class.

	BASE CLASS = none

	Copyright  1995 John Lindal. All rights reserved.

 ******************************************************************************/

#include <JStaticBuffer.h>
#include <string.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JStaticBuffer::JStaticBuffer
	(
	JCharacter* data
	)
{
	itsData = data;
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JStaticBuffer::~JStaticBuffer()
{
	delete [] itsData;
}

/******************************************************************************
 GetLength

 ******************************************************************************/

JSize
JStaticBuffer::GetLength()
	const
{
	if (itsData != NULL)
		{
		return strlen(itsData);
		}
	else
		{
		return 0;
		}
}
