/******************************************************************************
 JUNIXPrefsFile.h

	Interface for the JUNIXPrefsFile class

	Copyright  1995 John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JUNIXPrefsFile
#define _H_JUNIXPrefsFile

#include <JPrefsFile.h>

class JUNIXPrefsFile : public JPrefsFile
{
public:

	static JError	Create(const JCharacter* fileName, JUNIXPrefsFile** obj);
	static JError	OKToCreate(const JCharacter* fileName);

	virtual ~JUNIXPrefsFile();

	static JString	GetFullName(const JCharacter* fileName);

protected:

	JUNIXPrefsFile(const JCharacter* fileName);

private:

	// not allowed

	JUNIXPrefsFile(const JUNIXPrefsFile& source);
	JUNIXPrefsFile& operator=(const JUNIXPrefsFile& source);

public:

	// JError classes

	static const JCharacter* kNoHomeDirectory;

	static const JCharacter* kNoHomeDirectoryMsg;

	class NoHomeDirectory : public JError
		{
		public:

			NoHomeDirectory()
				:
				JError(kNoHomeDirectory, kNoHomeDirectoryMsg)
			{ };
		};
};

#endif
