#include <JTextProgressDisplay.h>
#include <JStopWatch.h>
#include <jTime.h>
#include <JString.h>
#include <jCommandLine.h>
#include <iostream.h>

int
main()
{
	JTextProgressDisplay pg;

	JStopWatch timer;

	pg.FixedLengthProcessBeginning(6, "Calculating scores...", kTrue, kFalse);

	timer.StartTimer();

	long i;
	for (i=1;i<=6;i++)
		{
		JWait(2.0);

		if (!pg.IncrementProgress())
			{
			break;
			}
		}

	timer.StopTimer();

	pg.ProcessFinished();

	JString timeString = timer.PrintTimeInterval();
	cout << timeString;

	pg.VariableLengthProcessBeginning("Processing examples...", kTrue, kFalse);

	for (i=1;i<=6;i++)
		{
		JWait(2.0);

		if (!pg.IncrementProgress(JString(i)))
			{
			break;
			}
		}

	pg.ProcessFinished();

	return 0;
}
