/******************************************************************************
 JXMenuManager.cc

	Global object to help manage pull-down menus.

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXMenuManager.h>
#include <JXMenu.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXMenuManager::JXMenuManager()
{
	itsOpenMenuList = new JPtrArray<JXMenu>;
	assert( itsOpenMenuList != NULL );
}

/******************************************************************************
 Destructor

	We should not be deleted until all JXMenus have been deleted.

 ******************************************************************************/

JXMenuManager::~JXMenuManager()
{
	assert( itsOpenMenuList->IsEmpty() );

	delete itsOpenMenuList;
}

/******************************************************************************
 CloseCurrentMenus

 ******************************************************************************/

void
JXMenuManager::CloseCurrentMenus()
{
	if (!itsOpenMenuList->IsEmpty())
		{
		(itsOpenMenuList->FirstElement())->Close();
		assert( itsOpenMenuList->IsEmpty() );
		}
}
