/******************************************************************************
 JXPTPageSetupDialog.cc

	Clients must call BuildWindow() after constructing the object.
	Derived classes must override BuildWindow() and call SetObjects()
	at the end of their implementation.

	BASE CLASS = JXDialogDirector

	Copyright  1999 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <JXPTPageSetupDialog.h>
#include <JXPTPrinter.h>
#include <JXWindow.h>
#include <JXTextButton.h>
#include <JXIntegerInput.h>
#include <JXStaticText.h>
#include <jXGlobals.h>
#include <JString.h>
#include <jProcessUtil.h>
#include <jFileUtil.h>
#include <fstream.h>
#include <stdio.h>
#include <jAssert.h>

/******************************************************************************
 Constructor

 ******************************************************************************/

JXPTPageSetupDialog::JXPTPageSetupDialog()
	:
	JXDialogDirector(JXGetApplication(), kTrue)
{
}

/******************************************************************************
 Destructor

 ******************************************************************************/

JXPTPageSetupDialog::~JXPTPageSetupDialog()
{
}

/******************************************************************************
 BuildWindow

 ******************************************************************************/

void
JXPTPageSetupDialog::BuildWindow
	(
	const JCharacter*	printCmd,
	const JSize			pageWidth,
	const JSize			pageHeight,
	const JSize			minPageHeight
	)
{
// begin JXLayout

    JXWindow* window = new JXWindow(this, 370,150, "");
    assert( window != NULL );
    SetWindow(window);

    JXStaticText* obj1 =
        new JXStaticText("Print command:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,20, 100,19);
    assert( obj1 != NULL );

    JXTextButton* okButton =
        new JXTextButton("OK", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 219,119, 72,22);
    assert( okButton != NULL );
    okButton->SetShortcuts("^M");

    JXTextButton* cancelButton =
        new JXTextButton("Cancel", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 70,120, 70,20);
    assert( cancelButton != NULL );

    itsPrintCmd =
        new JXInputField(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 110,20, 240,20);
    assert( itsPrintCmd != NULL );

    itsWidth =
        new JXIntegerInput(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 90,60, 40,20);
    assert( itsWidth != NULL );

    JXStaticText* obj2 =
        new JXStaticText("Page width:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,60, 80,20);
    assert( obj2 != NULL );

    JXStaticText* obj3 =
        new JXStaticText("Page height:", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 10,80, 80,20);
    assert( obj3 != NULL );

    itsHeight =
        new JXIntegerInput(window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 90,80, 40,20);
    assert( itsHeight != NULL );

    JXStaticText* obj4 =
        new JXStaticText("characters", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 130,60, 70,20);
    assert( obj4 != NULL );

    JXStaticText* obj5 =
        new JXStaticText("lines", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 130,80, 70,20);
    assert( obj5 != NULL );

    itsPrintTestButton =
        new JXTextButton("Print test page", window,
                    JXWidget::kHElastic, JXWidget::kVElastic, 220,70, 110,20);
    assert( itsPrintTestButton != NULL );

// end JXLayout

	SetObjects(okButton, cancelButton, itsPrintCmd, printCmd,
			   itsWidth, pageWidth, itsHeight, pageHeight, minPageHeight,
			   itsPrintTestButton);
}

/******************************************************************************
 SetObjects (protected)

 ******************************************************************************/

void
JXPTPageSetupDialog::SetObjects
	(
	JXTextButton*		okButton,
	JXTextButton*		cancelButton,
	JXInputField*		printCmdInput,
	const JCharacter*	printCmd,
	JXIntegerInput*		widthInput,
	const JSize			pageWidth,
	JXIntegerInput*		heightInput,
	const JSize			pageHeight,
	const JSize			minPageHeight,
	JXTextButton*		printTestButton
	)
{
	itsPrintCmd        = printCmdInput;
	itsWidth           = widthInput;
	itsHeight          = heightInput;
	itsPrintTestButton = printTestButton;

	(okButton->GetWindow())->SetTitle("Page Setup");
	SetButtons(okButton, cancelButton);

	itsPrintCmd->SetText(printCmd);
	itsPrintCmd->SetIsRequired();

	itsWidth->SetValue(pageWidth);
	itsWidth->SetLowerLimit(1);

	itsHeight->SetValue(pageHeight);
	itsHeight->SetLowerLimit(minPageHeight);

	ListenTo(itsPrintTestButton);
}

/******************************************************************************
 SetParameters

 ******************************************************************************/

JBoolean
JXPTPageSetupDialog::SetParameters
	(
	JXPTPrinter* p
	)
	const
{
	const JString& printCmd = itsPrintCmd->GetText();

	JInteger w,h;
	JBoolean ok = itsWidth->GetValue(&w);
	assert( ok );
	ok = itsHeight->GetValue(&h);
	assert( ok );

	const JBoolean changed =
		JI2B( printCmd != p->GetPrintCmd() ||
			  JSize(w) != p->GetPageWidth() ||
			  JSize(h) != p->GetPageHeight() );

	p->SetPrintCmd(printCmd);
	p->SetPageWidth(w);
	p->SetPageHeight(h);
	return changed;
}

/******************************************************************************
 Receive (protected)

 ******************************************************************************/

void
JXPTPageSetupDialog::Receive
	(
	JBroadcaster*	sender,
	const Message&	message
	)
{
	if (sender == itsPrintTestButton && message.Is(JXButton::kPushed))
		{
		PrintTestPage();
		}

	else
		{
		JXDialogDirector::Receive(sender, message);
		}
}

/******************************************************************************
 PrintTestPage (private)

 ******************************************************************************/

void
JXPTPageSetupDialog::PrintTestPage()
{
	JInteger i,w,h;
	if (itsPrintCmd->InputValid() &&
		itsWidth->GetValue(&w) && itsHeight->GetValue(&h))
		{
		const JString fileName = tmpnam(NULL);

		ofstream output(fileName);
		for (i=1; i<=w; i++)
			{
			output << JCharacter('0' + i%10);
			}
		output << '\n';
		for (i=2; i<=h; i++)
			{
			output << i << '\n';
			}
		output.close();

		const JString sysCmd  = itsPrintCmd->GetText() + " " + JPrepArgForExec(fileName);
		JError err = JExecute(sysCmd, NULL);
		if (!err.OK())
			{
			err.ReportError();
			}

		err = JRemoveFile(fileName);
		assert_ok( err );
		}
}
