/******************************************************************************
 JXStringList.h

	Interface for the JXStringList class

	Copyright  1996 by John Lindal. All rights reserved.

 ******************************************************************************/

#ifndef _H_JXStringList
#define _H_JXStringList

#include <JXTable.h>
#include <JPtrArray.h>
#include <JRunArray.h>
#include <JFontStyle.h>

class JString;

class JXStringList : public JXTable
{
public:

	static JXStringList*	Create(JXScrollbarSet* scrollbarSet, JXContainer* enclosure,
									 const HSizingOption hSizing, const VSizingOption vSizing,
									 const JCoordinate x, const JCoordinate y,
									 const JCoordinate w, const JCoordinate h);

	virtual ~JXStringList();

	const JPtrArray<JString>&	GetStringList() const;
	void						SetStringList(const JPtrArray<JString>* list);

	void	GetFont(JString* name, JSize* size) const;
	void	SetFont(const JCharacter* name, const JSize size);

	JFontStyle	GetStyle(const JIndex index) const;
	void		SetStyle(const JIndex index, const JFontStyle style);
	void		SetStyles(const JRunArray<JFontStyle>& styleList);

	// called by urgent task

	void	AdjustColWidth();

protected:

	JXStringList(JXScrollbarSet* scrollbarSet, JXContainer* enclosure,
				 const HSizingOption hSizing, const VSizingOption vSizing,
				 const JCoordinate x, const JCoordinate y,
				 const JCoordinate w, const JCoordinate h);

	void	JXStringListX();

	virtual void	TableDrawCell(JPainter& p, const JPoint& cell, const JRect& rect);
	virtual void	ApertureResized(const JCoordinate dw, const JCoordinate dh);
	virtual void	Receive(JBroadcaster* sender, const Message& message);

private:

	const JPtrArray<JString>*	itsList;	// we don't own this
	JRunArray<JFontStyle>*		itsStyles;

	JString*	itsFontName;
	JSize		itsFontSize;
	JCoordinate	itsMinColWidth;

private:

	// not allowed

	JXStringList(const JXStringList& source);
	const JXStringList& operator=(const JXStringList& source);
};


/******************************************************************************
 GetStringList

 ******************************************************************************/

inline const JPtrArray<JString>&
JXStringList::GetStringList()
	const
{
	return *itsList;
}

/******************************************************************************
 GetStyle

 ******************************************************************************/

inline JFontStyle
JXStringList::GetStyle
	(
	const JIndex index
	)
	const
{
	return itsStyles->GetElement(index);
}

/******************************************************************************
 SetStyle

 ******************************************************************************/

inline void
JXStringList::SetStyle
	(
	const JIndex		index,
	const JFontStyle	style
	)
{
	itsStyles->SetElement(index, style);
	TableRefreshCell(index,1);
}

#endif
