/******************************************************************************
 jXCSFIcons.cc

	Copyright  1996-98 by John Lindal. All rights reserved.

 ******************************************************************************/

#include <jXCSFIcons.h>

/* XPM */
static char * plain_file_xpm[] = {
"15 15 5 1",
" 	c None",
".	c gray40",
"X	c white",
"O	c gray50",
"-	c gray50",
"               ",
"  ........     ",
"  .XXXXXX..    ",
"  .XXXXXX.X.   ",
"  .XXXXXX...O  ",
"  .XXXXXXXX.O  ",
"  .X----XXX.O  ",
"  .XXXXXXXX.O  ",
"  .X---XXXX.O  ",
"  .XXXXXXXX.O  ",
"  .X-----XX.O  ",
"  .XXXXXXXX.O  ",
"  ..........O  ",
"   OOOOOOOOOO  ",
"               "};


/* XPM */
static char * source_file_xpm[] = {
"15 15 6 1",
" 	c None",
".	c gray40",
"X	c white",
"O	c gray50",
"-	c gray50",
"+	c blue",
"               ",
"  ........     ",
"  .XXXXXX..    ",
"  .XX+XXX.X.   ",
"  .X+XXXX...O  ",
"  .X+XXXXXX.O  ",
"  .X+XX---X.O  ",
"  .X+XXXXXX.O  ",
"  .X+XX---X.O  ",
"  .XX+XXXXX.O  ",
"  .XXXXX--X.O  ",
"  .XXXXXXXX.O  ",
"  ..........O  ",
"   OOOOOOOOOO  ",
"               "};


/* XPM */
static char * graphics_file_xpm[] = {
"15 15 7 1",
" 	c None",
".	c gray40",
"X	c white",
"O	c gray50",
"-	c red",
"+	c #000066660000",
"*	c blue",
"               ",
"  ........     ",
"  .XXXXXX..    ",
"  .X----X.X.   ",
"  .X----X...O  ",
"  .X---++XX.O  ",
"  .X--++++X.O  ",
"  .XXX++++X.O  ",
"  .XX*X++XX.O  ",
"  .X***XXXX.O  ",
"  .*****XXX.O  ",
"  .XXXXXXXX.O  ",
"  ..........O  ",
"   OOOOOOOOOO  ",
"               "};


/* XPM */
static char * library_file_xpm[] = {
"15 15 5 1",
" 	c None",
".	c gray40",
"X	c white",
"O	c gray50",
"-	c gray50",
"........       ",
".XXXXXX..      ",
".XX........    ",
".XX.XXXXXX..   ",
".XX.XXXXXX.X.  ",
".XX.XXXXXX...O ",
".XX.XXXXXXXX.O ",
".XX.X----XXX.O ",
".XX.XXXXXXXX.O ",
".XX.X---XXXX.O ",
".XX.XXXXXXXX.O ",
"....X-----XX.O ",
" OO.XXXXXXXX.O ",
"   ..........O ",
"    OOOOOOOOOO "};


/* XPM */
static char * folder_xpm[] = {
"15 15 5 1",
" 	c None",
".	c gray40",
"X	c wheat",
"-	c gray60",
"O	c gray50",
"               ",
"  .....        ",
" .XXXXX.       ",
".XXXXXXX...... ",
".-------XXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
".XXXXXXXXXXXX.O",
"..............O",
" OOOOOOOOOOOOOO",
"               "};


/* XPM */
static char * exec_xpm[] = {
"15 15 6 1",
" 	c None",
".	c gray40",
"X	c white",
"o	c wheat",
"O	c gray50",
"-	c black",
"               ",
"       .       ",
"      .X.      ",
"     .XXX.     ",
"    .XXXXX.    ",
"   .XXXX..X.   ",
"  .XXXX.oo.X.  ",
"   .XX----o.   ",
"   O.XXX.oo--  ",
"    O.XXX..--  ",
"     O.X.O --  ",
"      O.O      ",
"       O       ",
"               ",
"               "};


/* XPM */
static char * unknown_xpm[] = {
"15 15 3 1",
" 	c None",
".	c black",
"X	c #00009999FFFF",
"               ",
"  ...........  ",
"  .XXXXXXXXX.  ",
"  .XXXXXXXXX.  ",
"   .XXXXXXX.   ",
"   .XXXXXXX.   ",
"    .XXXXX.    ",
"    .XXXXX.    ",
"     .XXX.     ",
"     .XXX.     ",
"      .X.      ",
"      .X.      ",
"       .       ",
"               ",
"               "};


/******************************************************************************
 Access functions

 ******************************************************************************/

JXPM
JXGetPlainFileIcon()
{
	return JXPM(plain_file_xpm);
}

JXPM
JXGetSourceFileIcon()
{
	return JXPM(source_file_xpm);
}

JXPM
JXGetGraphicsFileIcon()
{
	return JXPM(graphics_file_xpm);
}

JXPM
JXGetLibraryFileIcon()
{
	return JXPM(library_file_xpm);
}

JXPM
JXGetFolderIcon()
{
	return JXPM(folder_xpm);
}

JXPM
JXGetExecIcon()
{
	return JXPM(exec_xpm);
}

JXPM
JXGetUnknownFileTypeIcon()
{
	return JXPM(unknown_xpm);
}
