/****************************************************************************
** $Id: qobjdefs.h,v 2.2 1997/08/06 15:05:38 hanord Exp $
**
** Macros and definitions related to QObject
**
** Created : 930419
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QOBJDEFS_H
#define QOBJDEFS_H

#include "qglobal.h"


// The following macros are our "extensions" to C++
// They are used, strictly speaking, only by the moc.

#define slots					// slots:   in class
#define signals protected			// signals: in class
#define emit					// emit signal

/* tmake ignore Q_OBJECT */
#define Q_OBJECT							      \
public:									      \
    QMetaObject *metaObject() const { return metaObj; }			      \
    const char  *className()  const;					      \
protected:								      \
    void	 initMetaObject();					      \
private:								      \
    static QMetaObject *metaObj;

/* tmake ignore Q_OBJECT */
#define Q_OBJECT_FAKE Q_OBJECT
						// macro for naming members
#if defined(_OLD_CPP_)
#define METHOD(a)	"0""a"
#define SLOT(a)		"1""a"
#define SIGNAL(a)	"2""a"
#else
#define METHOD(a)	"0"#a
#define SLOT(a)		"1"#a
#define SIGNAL(a)	"2"#a
#endif

#define METHOD_CODE	0			// member type codes
#define SLOT_CODE	1
#define SIGNAL_CODE	2


// Forward declarations so you don't have to include files you don't need

class QObject;
class QMetaObject;
class QSignal;
class QConnection;
class QEvent;

class QListM_QConnection;			// connection list
#define QConnectionList	  QListM_QConnection
#define QConnectionListIt QListIteratorM_QConnection

class QDictM_QListM_QConnection;		// signal dictionary
#define QSignalDict   QDictM_QListM_QConnection
#define QSignalDictIt QDictIteratorM_QListM_QConnection

class QListM_QObject;				// object list
#define QObjectList QListM_QObject

class QDictM_QMetaData;				// meta object dictionaries
#define QMemberDict QDictM_QMetaData


#endif // QOBJDEFS_H
