/****************************************************************************
** $Id: qsignal.h,v 2.1 1997/08/06 15:05:46 hanord Exp $
**
** Definition of QSignal class
**
** Created : 941201
**
** Copyright (C) 1992-1997 Troll Tech AS.  All rights reserved.
**
** This file is part of the free edition of Qt 1.31.
**
** See the file LICENSE included in the distribution for the usage
** and distribution terms, or http://www.troll.no/qt/license.html.
**
** IMPORTANT NOTE: You may NOT copy this file or any part of it into
** your own programs or libraries.
**
** (This file differs from the one in the commercial edition of Qt
** only by this comment.)
**
*****************************************************************************/

#ifndef QSIGNAL_H
#define QSIGNAL_H

#include "qobject.h"


class QSignal : private QObject			// signal class
{
public:
    QSignal( QObject *parent=0, const char *name=0 );

    const char *name() const		{ return QObject::name(); }
    void    setName( const char *name ) { QObject::setName(name); }

    bool    connect( const QObject *receiver, const char *member );
    bool    disconnect( const QObject *receiver, const char *member=0 );

    bool    isBlocked()	 const		{ return QObject::signalsBlocked(); }
    void    block( bool b )		{ QObject::blockSignals( b ); }

    void    activate()			{ activate_signal("x()"); }

private:
    void    dummy();
    Q_OBJECT_FAKE

private:	// Disabled copy constructor and operator=
    QSignal( const QSignal & ) {}
    QSignal &operator=( const QSignal & ) { return *this; }
};


#endif // QSIGNAL_H
