// $Id: AssDialog.h,v 1.2 1997/04/17 03:19:43 jharris Exp $

#ifndef AssDialog_h
#define AssDialog_h

#include <qdialog.h>
#include <qframe.h>
#include <qpushbt.h>
#include <qlist.h>

class AssDialog;

class AssPage : public QFrame
{
  Q_OBJECT
public:
  AssPage( AssDialog *, const char* = NULL );

protected:
  virtual const char *GetBackLabel();
  virtual const char *GetNextLabel();
  virtual const char *GetCancelLabel();

protected:
  virtual void InitPage( bool );
  virtual void ExitPage( bool );

protected:
  bool direction;
  // FALSE: Entered via Back button

  friend class AssDialog;
};

class AssDialog : public QDialog
{
  Q_OBJECT
public:
  AssDialog( QWidget *parent = 0,
             const char *caption = 0, 
             const char *name = 0 );

  ~AssDialog();

  void AddPage( AssPage * );

  int Exec();

private:
  void InitPage( bool );
  void ExitPage( bool );

private slots:  
  void Back();
  void Next();
  void Cancel();

private:
  QPushButton *back, *next, *cancel;
  QSize maxPageSize;

  QList<AssPage> pageList;
  AssPage *currentPage;

  friend class AssPage;
};


#endif
