// $Id: Project.h,v 1.3 1997/04/23 03:04:44 jharris Exp $

#ifndef Project_included
#define Project_included

#include <qstring.h>
#include <qlist.h>
#include <qfile.h>
#include <qobject.h>

class ProjectWnd;
class DlgParser;
class DialogWnd;
class Pages;

#include "DlgObject.h"

// Often needed: a simple list of strings
typedef QList<QString> StringList;

// A Makefile is simply a list of textlines
typedef StringList Makefile;

typedef QListIterator<QString> StringIter;

class Project : public DlgObject
{
  Q_OBJECT

public:
  Project( ProjectWnd &projectWnd, const QString &fileName );

  virtual QString GetType();
  virtual DlgObjectType GetObjType();
  // Retrieves Object Type

  const QString &GetProjectName() const;

  void SetProjectName( const QString & );

  DlgObjList& GetObjects();

  bool HasChanged() const;

  void GenerateAllObjects();
  // Generate all the objects

  void GenerateMakeFile();

  void SetMakeFileName( const QString & );
  void SetMakeFileTemplateName( const QString & );

public slots:
  virtual bool Load();
  // Load from disk

  virtual bool Save();
  // Save to disk

  virtual bool Generate( bool = TRUE );
  // Generate c++ files (the object must be shown/loaded or not)

  virtual void Hide();
  // Hide from screen

  virtual void Show();
  // Show (again)

  virtual void Raise();
  // Raise window

  virtual bool EnterProject( const Project * );
  // Added in a project, remember this project

  virtual bool LeaveProject( const Project * );
  // Removed from a Project, forget this project

  bool InProject( const Project * = NULL );
  // Is in (specified) Project

  virtual void CPAvailable( bool );
  // Somehow c&p data was made available

  void AddToProject( DlgObject * );
  // Add this Dialog to the Project

  void RemoveFromProject( DlgObject * );
  // Remove this Dialog from the Project

  void Rename();
  // Rename project (itsName)

private slots:
  void RestoreProject(QString &, QString & );

  void ObjClosed( DlgObject * );

  void AddObject();
  // Add a new object

private:
  QString itsName;
  // Projects name

  DlgObjList itsObjects;
  // The Dialogs which belongs into this Project

  StringList genSources, genHeaders, genMeta;
  // When generating the objects in GenerateAllObjects, we collect all
  // generated files.

  QString itsMakeFileName, itsMakeFileTemplateName;
  // The filenames of the Makefiles

  Makefile makefile;
  // The place to hold the generated Makefile

  bool autoGenerate;
};

typedef QList<Project> ProjectList;

inline DlgObjList& Project::GetObjects()
{
  return itsObjects;
}

inline QString Project::GetType()
{
  return "Project";
}

inline DlgObjectType Project::GetObjType()
{
  return DlgObject_Project;
}

inline const QString &Project::GetProjectName() const
{
  return itsName;
}

inline void Project::SetProjectName( const QString &newName )
{
  itsName = newName;
  status = DlgObject_Changed;
  emit Changed( this );
}

inline bool Project::HasChanged( ) const
{
  return status == DlgObject_Changed;
}

inline void Project::SetMakeFileName( const QString &str )
{
  itsMakeFileName = str;
}

inline void Project::SetMakeFileTemplateName( const QString &str )
{
  itsMakeFileTemplateName = str;
}

#endif
