#include "layout/BoxSpacing.h"
#include "layout/BoxSpacingPropPage.h"

#include "WidgetLayout.h"
#include "GuiTools.h"

#define Inherited LayoutItem

BoxSpacing::BoxSpacing
(
    QWidget*		parent,
    WidgetLayout*	widgetLayout,
    int			spacing
)
    :
    Inherited( widgetLayout ),
    itsFrame( NULL ),	
    itsSpacing( spacing )
{
    itsFrame = new Frame( parent, NULL );
    itsFrame->setFrameStyle( QFrame::WinPanel | QFrame::Raised );
    SetColor( itsFrame );
    itsFrame->show();
    
    widgetLayout->connect( itsFrame, SIGNAL(MousePress(QWidget*,QMouseEvent*)),
			   SLOT(LayoutMousePress(QWidget*,QMouseEvent*)) );
    widgetLayout->connect( itsFrame, SIGNAL(Paint(QWidget*)),
			   SLOT(LayoutPaint(QWidget*)) );
    widgetLayout->connect( 
	itsFrame,
	SIGNAL(MouseDoubleClick(QWidget*,QMouseEvent*)),
	SLOT(ProcessMouseDoubleClick(QWidget*,QMouseEvent*)) );
}


BoxSpacing::~BoxSpacing()
{
    itsFrame->parent()->removeChild( itsFrame );
    delete itsFrame;
}


void BoxSpacing::AddToLayout
(
    QBoxLayout*	layout
)
{
    layout->addWidget( itsFrame, 1 );

    switch( layout->direction() )
    {
	case QBoxLayout::LeftToRight:
	case QBoxLayout::RightToLeft:
	{
	    itsFrame->setMaximumSize( itsSpacing, QLayout::unlimited );
	    break;
	}
	case QBoxLayout::TopToBottom:
	case QBoxLayout::BottomToTop:
	    //case QBoxLayout::Up:
	    //case QBoxLayout::Down:
	{
	    itsFrame->setMaximumSize( QLayout::unlimited, itsSpacing );
	    break;
	}
    }

}


LayoutItem* BoxSpacing::FindLayoutItem
(
    QWidget*	widget
) const
{
    return (widget == itsFrame) ? this : (LayoutItem*)NULL;
}


void BoxSpacing::LowerWidget( void )
{
    itsFrame->lower();
}


void BoxSpacing::SaveContents( QTextStream&	stream,
			       QString		id ) const
{
    stream << GetItemName() << "-" << id << "{\n";
    
    stream << "\t\tSpacing {" << itsSpacing << "}\n";
    
    stream << "}\n";
}


bool BoxSpacing::RestoreKeyValue( const QString&	key,
				  const QString&	value )
{
    bool rc = TRUE;
    
    if( key == "Spacing" )
    {
	itsSpacing = value.toInt();
    }
    else 
    {
	rc = FALSE;
    }
    
    return rc;
}


void BoxSpacing::GenerateSource( QTextStream&	stream,
				 const QString&	layoutVarName,
				 const QString&	/*layoutId*/ ) const
{
    stream << '\t' << layoutVarName << "->addSpacing( " << itsSpacing <<
	" );\n";
}


QString BoxSpacing::GetItemName( void ) const
{
    return ItemName();
}


QWidget* BoxSpacing::GetPropertyPage
(
    QWidget*	parent
)
{
    return new BoxSpacingPropPage( this, parent, GetItemName() );
}


QRect BoxSpacing::GetGlobalGeometry( void ) const
{
    return GuiTools::GetGlobalGeometry( itsFrame );
}
