#include <qbutton.h> 

#include "ButtonPage.h"

#include "widget/DlgWidget.h"

#define Inherited ButtonPageData

ButtonPage::ButtonPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QButton* button = (QButton*)widget->GetWidget();
	
    itsText->setText( button->text() );
    isAutoRepeat->setChecked( button->autoRepeat() );
    isAutoResize->setChecked( button->autoResize() );
}


ButtonPage::~ButtonPage()
{
}


void ButtonPage::Apply( DlgWidget*	widget )
{
    QButton* button = (QButton*)widget->GetWidget();
    
    button->setText( itsText->text() );
    button->setAutoRepeat( isAutoRepeat->isChecked() );
    button->setAutoResize( isAutoResize->isChecked() );
}
