#ifndef ColorSelectDialog_included
#define ColorSelectDialog_included

#include <qpalette.h>

#include "ColorSelectDialogData.h"

class ColorSelectDialog : public ColorSelectDialogData
{
    Q_OBJECT

public:

    ColorSelectDialog
    (
	const QColor& color,
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~ColorSelectDialog();

    QColor GetColor( void ) const;
    // get the color the user selected

private:

    void UpdateSliders( const QColor& color );
    // update the values of the red, green, and blue sliders

    void UpdateTexts( const QColor& color );
    // update the red, green, and blue text fields

private slots:

    void ColorClicked( int );
    // called when a predefined color is clicked, the selected color is changed
    // to the color clicked

    void SliderChanged( int );
    // update the selected color when a slider is moved

    void TextChanged( const char* );
    // update the selected color when a color text is changed

private:

    enum 
    {
	Black,
	White,
	DarkGray,
	Gray,
	LightGray,
	Red,
	Green,
	Blue,
	Cyan,
	Magenta,
	Yellow,
	DarkRed,
	DarkGreen,
	DarkBlue,
	DarkCyan,
	DarkMagenta,
	DarkYellow
    };

};
#endif // ColorSelectDialog_included



extern void ChangeColor
( 
    QWidget*		widget,
    const QColor&	color 
);


