#include <qlined.h>
#include <qstring.h>

#include "LineEditPage.h"

#include "widget/DlgWidget.h"

#define Inherited LineEditPageData

LineEditPage::LineEditPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QLineEdit* edit = (QLineEdit*)widget->GetWidget();
    
    itsText->setText( edit->text() );

    switch( edit->echoMode() )
    {
	case QLineEdit::Normal:
	{
	    isEchoNormal->setChecked( TRUE );
	    break;
	}
	case QLineEdit::NoEcho:
	{
	    isEchoNone->setChecked( TRUE );
	    break;
	}
	case QLineEdit::Password:
	{
	    isEchoPassword->setChecked( TRUE );
	    break;
	}
    }

    QString str;
    str.setNum( edit->maxLength() );
    itsMaxLength->setText( str );

    isFrameShown->setChecked( edit->frame() );
}


LineEditPage::~LineEditPage()
{
}


void LineEditPage::Apply( DlgWidget*	widget )
{
    QLineEdit* edit = (QLineEdit*)widget->GetWidget();
    
    edit->setText( itsText->text() );

    QLineEdit::EchoMode echo = QLineEdit::Normal;
    if( isEchoNone->isChecked() )
    {
	echo = QLineEdit::NoEcho;
    }
    else if( isEchoPassword->isChecked() )
    {
	echo = QLineEdit::Password;
    }
    edit->setEchoMode( echo );

    QString str = itsMaxLength->text();
    edit->setMaxLength( str.toInt() );

    edit->setFrame( isFrameShown->isChecked() );
}

