#include <qscrbar.h>
#include <qstring.h>

#include "ScrollBarPage.h"

#include "widget/DlgWidget.h"

#define Inherited ScrollBarPageData

ScrollBarPage::ScrollBarPage
(
    DlgWidget* widget,
    QWidget* parent,
    const char* name
)
    :
    Inherited( parent, name )
{
    QScrollBar* scroll = (QScrollBar*)widget->GetWidget();
    
    switch( scroll->orientation() )
    {
	case QScrollBar::Horizontal:
	{
	    isHoriz->setChecked( TRUE );
	    break;
	}
	case QScrollBar::Vertical:
	{
	    isVert->setChecked( TRUE );
	    break;
	}
    }
    
    QString str;
    itsMinValue->setText( str.setNum( scroll->minValue() ) );
    itsMaxValue->setText( str.setNum( scroll->maxValue() ) );
    itsLineStep->setText( str.setNum( scroll->lineStep() ) );
    itsPageStep->setText( str.setNum( scroll->pageStep() ) );
    itsInitialValue->setText( str.setNum( scroll->value() ) );
}


ScrollBarPage::~ScrollBarPage()
{
}


void ScrollBarPage::Apply( DlgWidget*	widget )
{
    QScrollBar* scroll = (QScrollBar*)widget->GetWidget();
    
    QScrollBar::Orientation orient = QScrollBar::Vertical;
    
    if( isHoriz->isChecked() )
    {
	orient = QScrollBar::Horizontal;
    }
    
    scroll->setOrientation( orient );
    
    QString str = itsMinValue->text();
    int min = str.toInt();
    str = itsMaxValue->text();
    int max = str.toInt();
    
    scroll->setRange( min, max );
    
    str = itsLineStep->text();
    int line = str.toInt();
    str = itsPageStep->text();
    int page = str.toInt();
    
    scroll->setSteps( line, page );
    
    str = itsInitialValue->text();
    scroll->setValue( str.toInt() );
}
