#ifndef DlgButtonGroup_included
#define DlgButtonGroup_included

#include <qstring.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"
#include "widget/ButtonGroup.h"

class DlgButtonGroup : public DlgWidget
{

public:

    DlgButtonGroup
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgButtonGroup();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgButtonGroup's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QButtonGroup *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QButtonGroup *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    virtual void GenerateExtraSource( QTextStream&		stream,
				      const QString&		varName,
				      const QList<DlgWidget>&	zOrdering );
    // Generate extra source for a widget, after all the widgets have been
    // constructed and initialized

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list
    
    static const QStrList& GetSignalList( void );
    // method to return the list of signals

private: // static data

    static QStrList	itsSignals;
    // list of the signals that can be connected to this widget

private:

    ButtonGroup*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgButtonGroup::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgButtonGroup::GetHeaderFilename() const
{
    return "<qbttngrp.h>";
}

inline QString DlgButtonGroup::GetWidgetClass() const
{
    return "QButtonGroup";
}

inline void DlgButtonGroup::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}

#endif // DlgButtonGroup_included
