#ifndef DlgLineEdit_included
#define DlgLineEdit_included

#include <qstring.h>
#include <qstrlist.h>

#include "widget/DlgWidget.h"
#include "widget/LineEdit.h"

class DlgLineEdit : public DlgWidget
{

public:

    DlgLineEdit
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgLineEdit();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgLineEdit's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QLineEdit *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QLineEdit *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes. varName already
    // has a leading tab and the correct dereferencer

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    virtual void AddSignalsToList( QStrList&	signalList ) const;
    // add signals specific to a particular widget type to the list
    
    static const QStrList& GetSignalList( void );
    // method to return the list of signals

private: // static data

    static QStrList	itsSignals;
    // list of the signals that can be connected to this widget

private:

    LineEdit*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgLineEdit::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgLineEdit::GetHeaderFilename() const
{
    return "<qlined.h>";
}

inline QString DlgLineEdit::GetWidgetClass() const
{
    return "QLineEdit";
}

inline void DlgLineEdit::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}

#endif // DlgLineEdit_included
