#ifndef DlgProgressBar_included
#define DlgProgressBar_included

#include <qstring.h>

#include "widget/DlgWidget.h"
#include "widget/ProgressBar.h"

class DlgProgressBar : public DlgWidget
{

public:

    DlgProgressBar
    (
	QWidget*	parentWidget,
	const char*	name = NULL
    );

    virtual ~DlgProgressBar();
    
    virtual QWidget* GetWidget( void ) const;
    // return the DlgProgressBar's widget

    virtual void GetPropertyPages
    (
	QWidget*		parent,
	QList<QWidget>&		pages,
	QStrList&		labels
    );
    // Get the property pages and their labels for the widget

    virtual void SaveContents
    (
	QTextStream&	stream
    );
    // save the contents of the widget

    static void SaveQt
    (
       QTextStream &,
       const QProgressBar *
    );
    // Used by original Qt subclasses

    static bool RestoreQt
    (
       const QString &,
       const QString &,
       QProgressBar *
    );
    // Used by original Qt subclasses

    virtual bool RestoreKeyValue( QString &key, QString &value );
    // Restore a single key/value pair

    virtual QString GetHeaderFilename() const;
    // return the header filename for the widget

    virtual QString GetWidgetClass() const;
    // return the class name for the widget

    virtual void GenerateSource
    (
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // call GenSrc for the appropriate widget base classes

    static void GenSrc
    (
	DlgWidget&		dlgWidget,
	QTextStream&		stream,
	const QString&		varName,
	const QList<DlgWidget>&	zOrdering
    );
    // static method to actually generate the source

    virtual void GenerateCtor
    (
        QTextStream&            stream,
        const QString&          varName
    );
    // output a constructor for the widget.  The
    // ctor for leaves the output at the start of the next line


private:

    ProgressBar*	itsWidget;

    static int itsNextWidgetNum;
    // number of the next widget

};


inline QWidget* DlgProgressBar::GetWidget( void ) const
{
    return itsWidget;
}


inline QString DlgProgressBar::GetHeaderFilename() const
{
    return "<qprogbar.h>";
}

inline QString DlgProgressBar::GetWidgetClass() const
{
    return "QProgressBar";
}


inline void DlgProgressBar::GenerateSource
(
    QTextStream&		stream,
    const QString&		varName,
    const QList<DlgWidget>&	zOrdering
)
{
    GenSrc( *this, stream, varName, zOrdering );
}


#endif // DlgProgressBar_included
