static char *SccsId = "@(#)main.c 3.12 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : addproj/3.12

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 26-Mar-1987
Modified by       : S. de Graaf
Modification date : 03-Jun-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "dmstd.h"
#include "signal.h"
#ifdef ESE
#include "eseOption.h"
#include "tversion.h"
#endif

#define P_E fprintf (stderr,

#define HOSTLEN 10
char    nethost[HOSTLEN + 6] = "/";
int     hostlen;
int     cflag = 0;

char   *projlist = "./projlist";
char * projpath;
char   *cp_path;
char    buf[MAXLINE + 60];
char    Buf[MAXLINE + 60];

#ifndef ESE
char   *argv0 = "addproj";	/* program name */
char   *use_msg =		/* command line */
        "\nUsage: %s [-c] project\n\n";
#else
char   *argv0 = "addpr";	/* program name */
char   *use_msg =		/* command line */
        "\nUsage: %s [options] project\n\n";
#endif

#ifdef ESE
OptionSpec optionSpecs[] = {
    { "usage", NO, eseHelp, (void *) optionSpecs,
            "-usage:     addpr [options] project\nOptions (may be abbreviated) are:"},
    { "release", NO, esePrintString, (void *) TOOLVERSION,
            "    -release:              print the release number of this tool"},
    { "help", NO, eseHelp, (void *) optionSpecs,
            "    -help:                 print this list" },
    { "%etext", NO, eseText, (void *) NULL,
            "    -%etext:                print the '(int) & etext' number" },
    { "%nocheck", NO, eseTurnOn, (void *) & cflag,
            "    -%nocheck:             do not check process compatibility and lambda values" },
    { (char *) 0, (char) 0, (IFP) 0, (void *) 0, (char *) 0 },
};
#endif

main (argc, argv)
int     argc;
char   *argv[];
{
    FILE * fp;
    DM_PROJECT * lib_key, *cp_key;
    char   *lib_path;
    int     proj_cnt;

    if (!(argc == 2 || argc == 3)) {
	P_E use_msg, argv0);
	exit (1);
    }

#ifndef ESE
    if (argv[1][0] == '-' && argv[1][1] == 'c') {
	cflag = 1;
	*argv++;
    }
    projpath = argv[1];
#else
    if (eseOptionHandler (argc, argv, optionSpecs, 1, & projpath) > 0)
        exit (1);
#endif
    

    if (strlen (projpath) >= MAXLINE) {
	P_E "%s: too long project path name\n", argv0);
	exit (1);
    }

#ifndef MSDOS
    gethostname (&nethost[1], HOSTLEN);
    hostlen = strlen (nethost);

 /* ignore all signals */
    signal (SIGHUP, SIG_IGN);
    signal (SIGQUIT, SIG_IGN);
    signal (SIGTERM, SIG_IGN);
#endif
    signal (SIGINT, SIG_IGN);

    if (dmInit (argv0) == -1)
	exit (1);

    if (!(lib_key = dmOpenProject (projpath, PROJ_READ))) {
	P_E "%s: %s is no valid project\n", argv0, projpath);
	die (1);
    }
    lib_path = lib_key -> netpath;

    if (!(cp_key = dmOpenProject (".", PROJ_WRITE))) {
	P_E "%s: the cwd is no valid project\n", argv0);
	die (1);
    }
    cp_path = cp_key -> netpath;

    if (lib_key == cp_key) {
	P_E "%s: current project can not be added\n", argv0);
	die (1);
    }

    if (!cflag) {
	if (lib_key -> procid != cp_key -> procid) {
	    P_E "%s: process id's are not equal\n", argv0);
	    die (1);
	}

	if (lib_key -> lambda != cp_key -> lambda) {
	    P_E "%s: process lambda values are not equal\n", argv0);
	    die (1);
	}
    }

    if (!(fp = fopen (projlist, "r+"))) {
	P_E "%s: cannot open file: %s\n", argv0, projlist);
	die (1);
    }

    proj_cnt = 0;
    while (fscanf (fp, "%s", buf) != EOF) {
	++proj_cnt;
	if (strcmp (dmSubstituteEnvironmentVars(buf), lib_path) == 0) {
	    P_E "%s: %s already in projlist\n", argv0, lib_path);
	    die (1);
	}
    }

    if (++proj_cnt > DM_MAXPROJECTS) {
	P_E "%s: max projects reached, project not added\n", argv0);
	die (1);
    }

    ck_proj_loop (lib_path);

    fseek (fp, 0L, 2);
    fprintf (fp, "%s\n", lib_path);
    fclose (fp);

    die (0);
}

/* worthless junk code, i hate it. Thanks S. de Graaf!
 * [ps]
 */
ck_proj_loop (path)
char   *path;
{
    FILE * fp;
    char   *fname;
    char expandedPath[MAXLINE + 100];

    _dmSprintf (Buf, "%s/projlist", path);

    if (strncmp (Buf, nethost, hostlen) == 0) {
	fname = Buf + hostlen;
	if (fp = fopen (dmSubstituteEnvironmentVars(fname), "r"))
	    goto wh_loop;
    }

    fname = dmSubstituteEnvironmentVars(Buf);
    if (!(fp = fopen (fname, "r"))) {
	P_E "%s: cannot read file: %s\n", argv0, fname);
	die (1);
    }

wh_loop: 
    while (fscanf (fp, "%s", buf) != EOF) {
	if (strcmp (dmSubstituteEnvironmentVars(buf), cp_path) == 0) {
	    P_E "%s: current project already in %s\n", argv0, fname);
	    die (1);
	}
	ck_proj_loop (buf);
    }

    fclose (fp);
}

dmError (s)
char   *s;
{
    P_E "%s: ", argv0);
    dmPerror (s);
}

die (status)
int     status;
{
    dmQuit ();
    if (status)
	P_E "%s: -- program aborted --\n", argv0);
    exit (status);
}
