static char *SccsId = "@(#)cmaperror.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : cacdcmap/4.1

Language          : C
Operating system  : BSD4.2 | BSD4.3 | SYS5
Host machine      : HP9000s[358]00 | GOULD PN6000 | APOLLO DN[34]000

Author(s)         : P. Bingley
Creation date     : 18-Aug-1988
Modified by       : S. de Graaf
Modification date : 17-Feb-1989


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 781708

        COPYRIGHT (C) 1988-1989, All rights reserved
**********************************************************/

#include <stdio.h>
#include "cmaperror.h"

/* External Declarations */

/* Global Declarations */
int	cacdcmaperrno;

char	*cacdcmaperrors[] = {
    /* NOINIT	    */	"cacd cmap not initialized",
    /* NOCMAP	    */	"cannot create colormap",
    /* BADCMAP	    */	"invalid standard colormap",
    /* NOGC	    */	"cannot create graphics context",
    /* NOCORE	    */	"no more core",
    /* BADCOLOR	    */	"invalid color specification",
    /* BADID	    */	"invalid id specified",
    /* ARRAYTOSMALL */	"affected id array to small",
    /* BADERROR	    */	"invalid error code"
};

int	CacdCmapError();

/* Local Declarations */

/*********************************************************/


int CacdCmapError(string, fatal)
char	*string;
int	fatal;
{
    /* if illegal error code */
    if(cacdcmaperrno > CMAPMAXERROR) {
	cacdcmaperrno = BADERROR;
	if(!fatal) {
	    return(0);
	}
    }

    /* print the error message */
    fprintf(stderr, "%s: %s\n", (string ? string : ""),
			cacdcmaperrors[cacdcmaperrno]);

    if(fatal) {
	exit(cacdcmaperrno);
    }
    return(1);
}
