%{
/* SccsId = "@(#)cif_lex.l 4.1 (TU-Delft) 05/24/90" */
/**********************************************************

Name/Version      : ccif/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : T.G.R. van Leuken
Creation date     : 15-Sep-1988
Modified by       : S. de Graaf
Modification date : 20-Sep-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988, All rights reserved
**********************************************************/

extern int yylval;
int rotate;
char userChar[BUFSIZ];
char c;
int lineno=1;

/*
**  Redefines of standard lex input/unput macro's
**  Note: No line counter is include here !
*/

/* [ps]
#undef  input
#define input() (\
((yytchar=(yysptr>yysbuf)?(*--yysptr):getc(yyin)) == EOF)?\
(0):(yytchar))

#undef  unput
#define unput(c) { *yysptr++ = (c); }

#define GETC() (yysptr>yysbuf)?(*--yysptr):getc(yyin)
*/

#define GETC() input(yyin)

#ifdef FLEX_SCANNER
int yylineno = 1;
#undef yywrap
#endif

%}

%start 	layer_code other user

%%


<other>[-]?[0-9]+		{BEGIN other; yylval = atoi (yytext); return(INTEGER);}
"("			{
			i = 0;
			while (i>=0) {
			c = input();
			if (c == '(') i++;
			if (c == ')') i--;
			if (c == '\n') yylineno++;
			}
			}
;			{BEGIN user; rotate = 0; return(SEMI);}
P			{BEGIN other; return(POLYGON);}
B			{BEGIN other; return(BOX);}
R			{BEGIN other; if (rotate == 0) return(ROUNDFLASH); else return(ROTATE);}
W			{BEGIN other; return(WIRE);}
L 			{BEGIN layer_code; return(LAYER);}
DS			{BEGIN other; return(START);}
DF			{BEGIN other; return(FINISH);}
DD			{BEGIN other; return(DELETE);}
C			{rotate = 1; BEGIN other; return(CALL);}
E			{BEGIN other; return(END);}
T			{BEGIN other; return(TRANS);}
TR			{BEGIN other; return(TRANS);}
MX			{BEGIN other; return(MX);}
MY			{BEGIN other; return(MY);}
<layer_code>[0-9A-Z]+	{BEGIN other; return(SHORTNAME);}
<user>[0-9]		{BEGIN other; yylval = atoi (yytext); 
			i = 0;
			while ((userChar[i]=input()) != ';')
			{
				if (userChar[i] == '\n') yylineno++;
				i++; 
			}
			unput(userChar[i]); 
			userChar[i] = '\0'; 
			return(USER);}
.			;
"\n"			yylineno++;
%%
yywrap ()
{
    if (feof (yyin)) {
	pr_exit (05, 7, 0);
    }
    return (0);
}
