/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/
static int counter = 0;

dictionary::dictionary() {
        char *tempval;
        char *templ;

	templ = new char [24];

	sprintf (templ, "/usr/tmp/x%dXXXXXX", counter);
        counter++;

        tempval = mktemp (templ);
	db = dbOpen (tempval);
	key.dptr = NULL;
	key.dsize = 0;
	data.dptr = NULL;
	data.dsize = 0;
#ifdef DMEM
    dict_nbyte += sizeof(class dictionary);
    dict_maxnbyte = dict_nbyte > dict_maxnbyte ? dict_nbyte:dict_maxnbyte;
#endif
}

dictionary::~dictionary() {
#ifdef DMEM
    dict_nbyte -= sizeof(class dictionary);
#endif
    if(db)
	dbClose(&db);
}

void dictionary::store(char *item_key, char *item_data) {
    key.dptr = item_key;
    key.dsize= strlen(item_key) + 1;
    data.dptr = (char *) &item_data;
    data.dsize= sizeof(int);
    dbstore(db, &key, &data);
}

char *dictionary::fetch(char *item_key) {
    int *n;
    datum *helpdata;

    key.dptr = item_key;
    key.dsize= strlen(item_key) + 1;
    helpdata = dbfetch(db, &key);
    if(helpdata -> dptr == NULL)
	return(NULL);
    bmove ((char *)&n, (char *)helpdata -> dptr, helpdata -> dsize);
    return (char *) n;
}

void dictionary::print() {
	int *n;
	datum *helpkey;
	datum *helpdata;

	for (helpkey = firstkey(db); 
	     helpkey -> dptr != NULL; 
	     helpkey = nextkey(db, helpkey))
	{
	    helpdata = dbfetch(db, helpkey);
	    bmove ((char *)&n, (char *)helpdata -> dptr, helpdata -> dsize);
	    fprintf(stderr,"key: %s, data: %x\n", helpkey -> dptr, n);
	}
}

#ifdef MSDOS

char *mktemp (char *filename)
{
    int i;

    tmpnam (filename);

    for (i = 0; filename[i] != '\0'; i++) {
        if (filename[i] == '.')
            filename[i] = '\0';
    }

    return (filename);
}

#endif
