static char *SccsId = "%Z%%M% %I% (%Q%) %G%";
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/
#include "sys_incl.h"
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

extern Dictionary *ntw_dict;
extern Dictionary *sym_dict;
extern Dictionary *inst_dict;

extern DM_CELL *dmkey;
extern DM_STREAM *dsp_term;
extern DM_STREAM *dsp_mc;
extern DM_STREAM *dsp_net;
extern DM_STREAM *dsp_sim_mc;
extern int cirflag;

int end_ntw (Network *ntw, int ext, int orig_mode)
{
    NetworkInstance *pinst;
    Netelem *pnet;
    int mode;

    if (sls_errno)
	mode = QUIT;
    else
	mode = orig_mode;

    if(!ext && !sls_errno && ntw -> netq && mode != QUIT)
	net_to_db (ntw -> netq);
    else if (ntw -> netq) {
	while(!ntw -> netq -> empty()) {
	    pnet = (Netelem *) ntw -> netq -> get();
	    if (pnet -> nmem)
		delete pnet -> nmem;
	    delete pnet;
	}
	delete ntw -> netq;
    }
    delete sym_dict;
    sym_dict = NULL;

    if(ntw->mcq)
    {
        while(!ntw->mcq -> empty()) {
	    pinst = (NetworkInstance *) ntw -> mcq -> get ();
	    delete pinst;
        }
	delete ntw -> mcq;
    }
    delete inst_dict;
    inst_dict = NULL;

    if (!ext) {
	if (dsp_term) dmCloseStream(dsp_term, mode);
	if (dsp_mc) dmCloseStream(dsp_mc, mode);
	if (dsp_net) dmCloseStream(dsp_net, mode);
#ifdef FUNCVIEW
	if (!cirflag && dsp_sim_mc)
	    dmCloseStream(dsp_sim_mc, mode);
#endif
	dsp_term = NULL;
	dsp_mc = NULL;
	dsp_net = NULL;
	dsp_sim_mc = NULL;

	dmCheckIn (dmkey, mode);

	if (sls_errno) {
	    sls_errno = BADNETW;
	    return(1);
	}
    }

    return(0);
}
