%{
/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "parse.h"
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

#ifdef __cplusplus
#define input yyinput
#endif

# if defined (sun) 
extern "C" {
/*
extern int input ();
*/
extern int yywrap ();
extern int yylook ();
extern int yyback(int *, int);
}
# endif /* sun */

#define YY_DECL extern "C" int yylex(void)

#ifdef FLEX_SCANNER
int yylineno = 1;
#define YYINCR(_count) yylineno += _count /* have to do this ourselves ... */
#else
#define YYINCR(_x)
#endif

%}

D	[0-9]
E	[DEde][-+]?{D}+

%%
"/*"			{ int thechar;
			  loop:
				while((thechar = input()) != '*')
				{
				    if (thechar == EOF || thechar == 0) 
					return(0);
				    if (thechar == '\n') YYINCR (1);
				}
				switch(input())
				{
				    case EOF:
				    case 0: return(0);
				    case '/': break;
				    case '*': unput('*'); goto loop;
				    case '\n': YYINCR (1);
				    default : goto loop;
				}
			}
"#"[^\n]*\n 		{ YYINCR (1);
			  parseLineStmt ((char *) yytext);
			}
"network"		{ return(NETWORK); }
"extern"		{ return(EXTERNSPEC); }
"terminal"		{ return(TERMINAL); }
"net"			{ return(NET)     ; }
"nenh"			{ return(NENH); }
"penh"			{ return(PENH); }
"ndep"			{ return(NDEP); }
"res"			{ return(RES)     ; }
"cap"			{ return(CAP)     ; }
"w"			{ return(T_WIDTH) ; }
"l"			{ return(T_LENGTH); }
"tr"			{ return(T_RISE); }
"tf"			{ return(T_FALL); }
".."			{ return(DOTDOT)  ; }
"="			{ return(ASSIGN)  ; }
"("			{ return(LPS)     ; }
")"			{ return(RPS)     ; }
"["			{ return(LSB)     ; }
"]"			{ return(RSB)     ; }
"{"			{ return(LCB)     ; }
"}"			{ return(RCB)     ; }
","			{ return(COMMA)   ; }
";"			{ return(SEMICOLON); }
"."			{ return(PERIOD); }
"@"			{ return(ATSIGN); }
[a-zA-Z][a-zA-Z0-9_]*		{ yylval.sval = (char *) yytext;
			  return(IDENTIFIER); }
{D}+			{ yylval.sval = (char *) yytext;
			  return(INTEGER); }
{D}+("."{D}+)?({E})?[fpnumkM]? { yylval.sval = (char *) yytext;
			  return(FLOAT); }
[\n]+			{ YYINCR(yyleng);}
[\t ]+			;

%%

int Input ()
{
    return (input ());
}

#ifdef MSDOS
int yywrap ()
{
    return (1);
}
#endif
