static char *SccsId = "%Z%%M% %I% (%Q%) %G%";
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : P.E. Menchen
Modification date : 18-Sep-1991
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1991,1994 All rights reserved
**********************************************************/
#include "sys_incl.h"
#include "class.h"
#include "mkdbdefs.h"
#include "mkdbincl.h"

#ifdef ESE
#include "eseOption.h"
#include "tversion.h"
#endif

int doSimpleNet = 1;
int genIntNet = 0;
int sflag = 0;
int externRequired = 0;
int forbidFirstCapital = 0;
int noWarnings = 0;
int interact = 0;
int cirflag = 0;
int dummy = 0;
int runCpp = 0;
char f_view[BUFSIZ];
char fn_incl[128];
char fn_cppout[80];
char *cpp_options;
char *defaultInclude;

char **globNets;
int globNets_cnt;
char **defGlobNets;
int defGlobNets_cnt;

#define GLOBNETFILE "global_nets"

#ifndef ESE
#ifdef SPICE
#define rcFile      ".putspicerc"
#else
#define rcFile      ".sls_mkdbrc"
#endif
#else
#ifdef SPICE
#define rcFile      ".putspicerc"
#else
#define rcFile      ".putslsrc"
#endif
#endif

Stack	*xs;
Stack	*attr_s;
Dictionary	*ntw_dict = NULL;
Dictionary	*dff_dict = NULL;
Dictionary	*sym_dict = NULL;
Dictionary	*inst_dict = NULL;
Network *dev_tab[DEVTABLENGTH];
Netelem *notconnected;

int dict_nbyte, dict_maxnbyte;
int queue_nbyte, queue_maxnbyte;
int stack_nbyte, stack_maxnbyte;
int int_nbyte, int_maxnbyte;
int char_nbyte, char_maxnbyte;
int ntwdef_nbyte, ntwdef_maxnbyte;
int ntwinst_nbyte, ntwinst_maxnbyte;
int inst_struct_nbyte, inst_struct_maxnbyte;
int netelem_nbyte, netelem_maxnbyte;
int net_ref_nbyte, net_ref_maxnbyte;
int xelem_nbyte, xelem_maxnbyte;

#ifndef ESE
#ifdef SPICE
char *argv0 = "putspice";
#ifdef FUNCVIEW
char *use_msg = "Usage: putspice [-dpsw] file_1 ... file_n";
#else
char *use_msg = "Usage: putspice [-psw] file_1 ... file_n";
#endif
#else
char *argv0 = "sls_mkdb";
#ifdef FUNCVIEW
char *use_msg = "Usage: sls_mkdb [-dpsw] file_1 ... file_n";
#else
char *use_msg = "Usage: sls_mkdb [-psw] file_1 ... file_n";
#endif
#endif
#else
#ifdef SPICE
char *argv0 = "putspice";
char *use_msg = "Usage: putspice [options] file_1 ... file_n";
#else
char *argv0 = "putsls";
char *use_msg = "Usage: putsls [options] file_1 ... file_n";
#endif
#endif /* ESE */
DM_PROJECT *dmproject = NULL;

FILE *fpstat;

extern DM_STREAM *dsp_term;
extern int externspec;
extern Network *curr_ntw;
extern int yylineno;
extern FILE *yyin;

#ifdef __cplusplus
  extern "C" {
#endif

void yyerror P_((char *));

int main P_((int argc, char **argv));
static void init_devs P_((void));
static void readGlobalNets P_((void));
static void readrcFile P_((void));
static int myscanf P_((int *fp_i, char *s));
static char *doCpp P_((char *fn));

#ifdef __cplusplus
  }
#endif

#ifdef ESE
OptionSpec optionSpecs[] = {
    { "usage", NO, eseHelp, (void *) optionSpecs,
#ifdef SPICE
            "Usage: putspice [options] files\nOptions (may be abbreviated) are: "},
#else
            "Usage: putsls [options] files\nOptions (may be abbreviated) are: "},
#endif
#ifdef FUNCVIEW
    { "dummy", NO, eseTurnOn, (void *) & dummy,
            "    -dummy:                   generate dummy circuit for all functional cells"},
#endif
    { "nowarnings", NO, eseTurnOn, (void *) & noWarnings,
            "    -nowarnings:              do not print warnings"},
#ifdef FUNCVIEW
    { "interactive", NO, eseTurnOn, (void *) & interact,
            "    -interactive:             interactive mode for picking equivalent cells"},
#endif
    { "%etext", NO, eseText, (void *) NULL,
            "    -%etext:                  print the '(int) & etext' number" },
    { "%help", NO, eseHelpAll, (void *) optionSpecs,
            "    -%help:                   print this list" },
    { "help", NO, eseHelp, (void *) optionSpecs,
            "    -help:                    print this list" },
#ifdef MSDOS
    { "%toolid", NO, esePrintString, (void *) TID,
            "    -%toolid:                 print the identifier of this tool"},
    { "release", NO, esePrintString, (void *) TVRS,
#else
    { "release", NO, esePrintString, (void *) TOOLVERSION,
#endif
            "    -release:                 print the release number of this tool"},
    { "preprocessor", NO, eseTurnOn, (void *) & runCpp,
            "    -preprocessor:            run C preprocessor" },
    { "silent", NO, eseTurnOn, (void *) & sflag,
            "    -silent:                  do it silently"  },
    { "%internal", NO, eseTurnOff, (void *) & doSimpleNet,
            "    -%internal:               create some kind of internal format"},
    { "%old", NO, eseTurnOn, (void *) & genIntNet,
            "    -%old:                    create some kind of old format"},
    { (char *) 0, (char) 0, (IFP) 0, (void *) 0, (char *) 0 },
};
#endif

main (int argc, char **argv)
{
    int     iarg;
    char   *fn;
    struct stat statBuf;
    char ** filelist = NULL;
    int eseIndex = 0;


#ifdef FUNCVIEW
    strcpy (f_view, FUNCTIONAL);
#else
    strcpy (f_view, CIRCUIT);
#endif

#ifndef ESE
    for (iarg = 1; iarg < argc && argv[iarg][0] == '-'; iarg++) {
	switch (argv[iarg][1]) {
#ifdef FUNCVIEW
	    case 'd': /* automatically generate dummy circuit cells */
		dummy = 1;
		break;
#endif
	    case 'w': 
		noWarnings = 1;
		break;
#ifdef FUNCVIEW
	    case 'I': /* interactive mode for circuit equivalence selection */
		interact = 1;
		break;
#endif
	    case 'p': /* run C preprocessor */
		runCpp++;
		break;
	    case 's': /* silent mode: no messages */
		sflag++;
		break;
	    case 'o':
		doSimpleNet = 0;
		break;
	    case 'i':
		genIntNet = 1;
		break;
	    default: 
		printf ("%s: -%s: Unknown option\n", argv[0], &argv[iarg][1]);
	}
    }

    if (iarg >= argc) {/* Only options ? */
	fprintf (stderr, "\n%s\n\n", use_msg);/* Usage: ...  */
	exit (0);
    }
#else
    filelist = (char **) calloc (argc, sizeof (char *));

    if ((eseOptionHandler (argc, argv, optionSpecs, argc, filelist) > 0) ||
            !filelist[0]) {
	fprintf (stderr, "\n%s\n\n", use_msg); /* Usage: ...  */
	exit (0);
    }
    if (cirflag)
        strcpy(f_view,CIRCUIT);
#endif /* ESE */

    signal_init ();
    fn_cppout[0] = '\0';
    cpp_options = NULL;
    defaultInclude = NULL;

    dmInit (argv0);
    dmproject = dmOpenProject (DEFAULT_PROJECT, DEFAULT_MODE);

    /* from now on the program must always exit via die () */

    readrcFile ();

#ifdef FUNCVIEW
    {

	/* Unfortunately, 

	if ((int)dmGetMetaDesignData (EXISTVIEW, dmproject, FUNCTIONAL) != 1) {
        }

	   does not work since it calls dmError if the view does not exist.
	*/

        DM_QDATA **view_list;
        int view_entry;
        int exist_funcview = 0;

	view_list = dmproject -> views;
	for (view_entry = 0; view_list[view_entry] != NULL; ++view_entry) {
	    if (strcmp (FUNCTIONAL, view_list[view_entry][0].point) == 0) {
                exist_funcview = 1;
	    }
	}
	if (!exist_funcview) {
	    cirflag = 1;    /* circuit view only mode, for old projects */
	    strcpy(f_view, CIRCUIT);
        }
    }
#endif

    readGlobalNets ();

    attr_s = new Stack(XSTACK_SIZE);
    xs = new Stack(XSTACK_SIZE);
    ntw_dict = new Dictionary;
    dff_dict = new Dictionary;
    init_devs ();
    init_bifs ();

    strcpy (fn_incl, "");

#ifndef ESE
    for ( ; iarg < argc; iarg++) {
	if (stat (argv[iarg], &statBuf) == 0) {
	    if(!sflag) {
		fprintf(stderr,"File %s:\n", argv[iarg]);
	    }
	    if (runCpp)
		fn = doCpp (argv[iarg]);
	    else
		fn = argv[iarg];
	    if((yyin = fopen(fn, "r")) != NULL)
	    {
		yyparse ();
		if (sym_dict) {
		    end_ntw (curr_ntw, externspec, COMPLETE);
		}

		fclose (yyin);
	    }
	    else {
		fprintf(stderr,"Cannot open %s\n", argv[iarg]);
	    }
	}
	else {
	    fprintf(stderr,"Cannot open %s\n", argv[iarg]);
	}

	if (fn_cppout[0]) {
	    unlink (fn_cppout);
	    fn_cppout[0] = '\0';
	}
    }
#else
    for (eseIndex = 0; filelist[eseIndex] != NULL; eseIndex++) {
	if (stat (filelist[eseIndex], &statBuf) == 0) {
	    if(!sflag) {
		fprintf(stderr,"File %s:\n", filelist[eseIndex]);
            }
	    if (runCpp)
		fn = doCpp (filelist[eseIndex]);
	    else
		fn = filelist[eseIndex];
	    if ((yyin = fopen(fn, "r")) != NULL) {
		yyparse ();
		if (sym_dict) {
		    end_ntw (curr_ntw, externspec, COMPLETE);
		}

		fclose (yyin);
	    }
	    else {
		fprintf(stderr,"Cannot open %s\n", filelist[eseIndex]);
	    }
	}
	else {
	    fprintf(stderr,"Cannot open %s\n", filelist[eseIndex]);
	}

	if (fn_cppout[0]) {
	    unlink (fn_cppout);
	    fn_cppout[0] = '\0';
	}
    }
#endif /* ESE */

    delete ntw_dict;
    ntw_dict = NULL;
    delete dff_dict;
    dff_dict = NULL;

    if (dmproject) {
	dmCloseProject (dmproject, COMPLETE);
    }
    dmQuit();

#ifdef DMEM
    if((fpstat = fopen("mem.stat","w")) == NULL)
	fprintf(stderr,"cannot open file stat\n");
    else
	print_memstat();
#endif
    return (0);
}

void die () {

    /* For some reason (bug in dmi ?) dmCloseProject (dmproject, QUIT)
       does not destroy the open streams of the cell that is checked out.
       So do an end_ntw (..., QUIT).
    */

    if (sym_dict) {
	end_ntw (curr_ntw, externspec, QUIT);
    }

    if (dmproject) {
	dmCloseProject (dmproject, QUIT);
    }

    dmQuit();

    if(sym_dict) {
	delete sym_dict;
	sym_dict = NULL;
    }
    if(ntw_dict) {
	delete ntw_dict;
	ntw_dict = NULL;
    }
    if(dff_dict) {
	delete dff_dict;
	dff_dict = NULL;
    }
    if(inst_dict) {
	delete inst_dict;
	inst_dict = NULL;
    }

    if (fn_cppout[0]) {
	unlink (fn_cppout);
	fn_cppout[0] = '\0';
    }

    exit(1);
}

static void init_devs () {
	Network *ntw;
	Queue *termq;
	Netelem *pterm;

	termq = new Queue (QueueType);
#ifdef SPICE
	pterm = new Netelem ("d", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("g", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("s", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("b", NULL, TermType);
	termq -> put ((Link *) pterm);
#else
	pterm = new Netelem ("g", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("d", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("s", NULL, TermType);
	termq -> put ((Link *) pterm);
#endif

	dev_tab[DevNenh] = ntw = new Network ("nenh");
	ntw->termq = termq;
	ntw->local = (existCell ("nenh", CIRCUIT) != 2);
	ntw_dict->store(ntw->ntw_name, (char *) ntw);

	dev_tab[DevPenh] = ntw = new Network ("penh");
	ntw->termq = termq;
	ntw->local = (existCell ("penh", CIRCUIT) != 2);
	ntw_dict->store(ntw->ntw_name, (char *) ntw);

	dev_tab[DevNdep] = ntw = new Network ("ndep");
	ntw->termq = termq;
	ntw->local = (existCell ("ndep", CIRCUIT) != 2);
	ntw_dict->store(ntw->ntw_name, (char *) ntw);

	termq = new Queue (QueueType);
	pterm = new Netelem ("p", NULL, TermType);
	termq -> put ((Link *) pterm);
	pterm = new Netelem ("n", NULL, TermType);
	termq -> put ((Link *) pterm);

	dev_tab[DevCap] = ntw = new Network ("cap");
	ntw->termq = termq;
	ntw->local = (existCell ("cap", CIRCUIT) != 2);
	ntw_dict->store(ntw->ntw_name, (char *) ntw);

	dev_tab[DevRes] = ntw = new Network ("res");
	ntw->termq = termq;
	ntw->local = (existCell ("res", CIRCUIT) != 2);
	ntw_dict->store(ntw->ntw_name, (char *) ntw);
}

#ifdef SPICE

double cvt_atof (char *s)
{
	double d;
	char    c;
	char    *pc;

	pc = s + strlen (s);
	while (!isdigit (*pc) && pc > s) pc--;
	pc++;

	c = *pc;
	*pc = '\0';
	switch(c) {
	    case 'G': 
	    case 'g': 
		d = 1e9 * atof(s);
		break;
	    case 'M': 
	    case 'm': 
		if ((*(pc+1) == 'E' || *(pc+1) == 'e')
		    && (*(pc+2) == 'G' || *(pc+2) == 'g'))
		    d = 1e6 * atof(s);
		else
		    d = 1e-3 * atof(s);
		break;
	    case 'k': 
		d = 1e3 * atof(s);
		break;
	    case 'u': 
	    case 'U': 
		d = 1e-6 * atof(s);
		break;
	    case 'n': 
	    case 'N': 
		d = 1e-9 * atof(s);
		break;
	    case 'p': 
	    case 'P': 
		    d = 1e-12 * atof(s);
		    break;
	    case 'f': 
	    case 'F': 
		d = 1e-15 * atof(s);
		break;
	    default: 
		d = atof(s);
	}

	return(d);
}

#else

double cvt_atof (char *s)
{
	double d;
	char    c = s[strlen(s) - 1];

	if(isdigit(c))
	    d =(float) atof(s);
	else {
	    s[strlen(s) - 1] = '\0';
	    switch(c) {
		case 'G': 
		    d = 1e9 * atof(s);
		    break;
		case 'M': 
		    d = 1e6 * atof(s);
		    break;
		case 'k': 
		    d = 1e3 * atof(s);
		    break;
		case 'm': 
		    d = 1e-3 * atof(s);
		    break;
		case 'u': 
		    d = 1e-6 * atof(s);
		    break;
		case 'n': 
		    d = 1e-9 * atof(s);
		    break;
		case 'p': 
		    d = 1e-12 * atof(s);
		    break;
		case 'f': 
		    d = 1e-15 * atof(s);
		    break;
		default: 
		    d = atof(s);
	    }
	}
    return(d);
}

#endif

static void readGlobalNets ()
{
    FILE *fp;
    int cnt;
    int i;
    char *fn;
    char buf[128];

    fp = fopen (GLOBNETFILE, "r");
    if (fp == NULL) {
        fn = (char *)dmGetMetaDesignData (PROCPATH, dmproject, GLOBNETFILE);
        fp = fopen (fn, "r");
    }

    if (fp) {

        cnt = 0;
        while (fscanf (fp, "%s", buf) > 0) {
            cnt++;
        }
        rewind (fp);

        globNets = new char * [cnt];
        defGlobNets = new char * [cnt];

        cnt = 0;
        while (fscanf (fp, "%s", buf) > 0) {
            for (i = 0; i < cnt; i++) {
                if (strcmp (globNets[i], buf) == 0)
                    break;   /* double specification of this global net */
            }
            if (i == cnt) {
                globNets[cnt] = new char [strlen (buf) + 1];
                strcpy (globNets[cnt], buf);
                cnt++;
            }
        }
        globNets_cnt = cnt;

        fclose (fp);
    }
    else {
        globNets_cnt = 0;
    }
}

char *isGlobalNet (char *s)
{
    int i;

    for (i = 0; i < globNets_cnt; i++) {
        if (strcmp (s, globNets[i]) == 0) {
            return (globNets[i]);
        }
    }

    return (NULL);
}

char *isDefGlobalNet (char *s)
{
    int i;

    for (i = 0; i < defGlobNets_cnt; i++) {
        if (strcmp (s, defGlobNets[i]) == 0) {
            return (defGlobNets[i]);
        }
    }

    return (NULL);
}

static void readrcFile ()
{
    char buf[256];
    int c;
    FILE *fp;
    char *fn;
    char *home;

    if ((fp = fopen (rcFile, "r")) == NULL) {

	if (home = getenv ("HOME")) {
	    fn = new char [strlen (home) + strlen (rcFile) + 2];
	    if (fn) {
		sprintf (fn, "%s/%s", home, rcFile);
		fp = fopen (fn, "r");
	    }
	}

	if (fp == NULL && dmproject) {
	    if (fn = (char *)dmGetMetaDesignData (PROCPATH, dmproject, rcFile))
		fp = fopen (fn, "r");
	}
    }
    else
	fn = rcFile;

    if (!fp) {
	return;
    }

    while (fscanf (fp, "%s", buf) > 0) {
	
	if (buf[0] == '#') {        
	    /* comment */
	}
	else if (strcmp (buf, "CPP_OPTIONS:") == 0) {
	    if (myscanf ((int *)fp, buf) > 0) {
		cpp_options = new char [strlen (buf) + 1];
		strcpy (cpp_options, buf);
	    }
	    else {
		rcReadError (fn, "CPP_OPTIONS:");
	    }
	}
	else if (strcmp (buf, "DEFAULT_INCLUDE:") == 0) {
	    if (myscanf ((int *)fp, buf) > 0) {
		defaultInclude = new char [strlen (buf) + 1];
		strcpy (defaultInclude, buf);
	    }
	    else {
		rcReadError (fn, "DEFAULT_INCLUDE:");
	    }
	}
	else if (strcmp (buf, "EXTERN_OBLIGATORY") == 0) {
	    externRequired = 1;
	}
	else if (strcmp (buf, "EXTERN_OBLIGATORY_ON") == 0) {
	    externRequired = 1;
	}
	else if (strcmp (buf, "RUN_CPP") == 0) {
	    runCpp = 1;
	}
	else if (strcmp (buf, "RUN_CPP_ON") == 0) {
	    runCpp = 1;
	}
	else if (strcmp (buf, "FORBID_FIRST_CAPITAL_ON") == 0) {
	    forbidFirstCapital = 1;
	}
	else {
	    rcReadError (fn, buf);
	}

	while ((c = getc (fp)) != '\n' && c != EOF); 
	if (c == EOF) break;

	/* skip everything until end of line */
    }

    fclose (fp);
}

static int myscanf (int *fp_i, char *s)
{
    FILE *fp = (FILE *)fp_i;   
      /* conversion is necessary since the C preprocessor 
         does not like FILE pointers as an argument */
    int i;
    int nonspace;
    int c;

    while ((c = getc (fp)) == ' ' || c == '\t');
  
    i = 0;
    nonspace = -1;
    if (c != EOF && c != '\n') {
	while (c != EOF && c != '\n') {
	    s[i] = c;
	    if (c != ' ' && c != '\t')
		nonspace = i;
	    c = getc (fp);
	    i++;
	}
    }

    s[nonspace + 1] = '\0';

    ungetc (c, fp);

    if (i > 0)
	return (1);
    else if (c == EOF)
	return (-1);
    else
	return (0);
}

void rcReadError (char *fn, char *s)
{
    fprintf (stderr, "Error in file '%s' for '%s'\n", fn, s);
    die ();
}

static char *doCpp (char *fn)
{
    FILE *fp;
    FILE *fp2;
    int c;
    struct stat statBuf;
    char    cmdstr[128];
    char    fn_cppin[128];

    sprintf (fn_cppin, "x%d.c", getpid ());
    sprintf (fn_cppout, "x%d.s", getpid ());

    if ((fp = fopen (fn_cppin, "w")) == NULL) {
	fprintf (stderr, "Cannot open %s\n", fn_cppin);
	return (fn);
    }

    if (defaultInclude) {
	fprintf (fp, "#include \"%s\"\n", defaultInclude);
    }

    fprintf (fp, "#line 1 \"%s\"\n", fn);

    if ((fp2 = fopen (fn, "r")) == NULL) {
	/* error message is not necessary, since it will also be given later */
	return (fn);
    }
    while ((c = getc (fp2)) != EOF)
	putc (c, fp);
    fclose (fp2);

    fclose (fp);

    if (stat ("/usr/lib/cpp", &statBuf) == 0)
	sprintf (cmdstr, "/usr/lib/cpp %s %s > %s", 
			 cpp_options, fn_cppin, fn_cppout);
    else if (stat ("/lib/cpp", &statBuf) == 0)
	sprintf (cmdstr, "/lib/cpp %s %s > %s", 
			 cpp_options, fn_cppin, fn_cppout);
    else
	sprintf (cmdstr, "cc -E %s %s > %s", cpp_options, fn_cppin, fn_cppout);

    if (system (cmdstr) == 0) {
	unlink (fn_cppin);
	return (fn_cppout);
    }
    else {
	unlink (fn_cppin);
	return (fn);
    }
}

void parseLineStmt (char *s)
{
    char *p;
    int i;

    /* Handles the following formats in the inputfile:
	  #line NUMBER FILENAME
	  #line NUMBER "FILENAME"
	  # NUMBER "FILENAME"
    */

    for (p = s + 1; *p && (*p == ' ' || *p == '\t'); p++);
    if ((*p >= '0' && *p <= '9')
	|| (*p == 'l' && *(p+1) == 'i' 
	    && *(p+2) == 'n' && *(p+3) == 'e' 
	    && (*(p+4) == ' ' || *(p+5) == '\t'))) {

	if (*p == 'l') {
	    p = p + 4;
	    while (*p && (*p == ' ' || *p == '\t')) p++;
	}

	if (sscanf (p, "%d", &yylineno) == 1) {

	    while (*p && !(*p == ' ' || *p == '\t')) p++;
	    while (*p && (*p == ' ' || *p == '\t')) p++;
	    if (*p == '"') p++;
	    if (*p) {
		i = 0;
		while (*p && *p != '"' 
		       && !(*p == ' ' || *p == '\t')) {
		    fn_incl[i++] = *p++;
		}
		fn_incl[i] = '\0';
	    }
	}
	else {
	    yylineno--;
	    yyerror (NULL);
	}
    }
    else {
	yylineno--;
	yyerror (NULL);
    }
}

int dmError (char *s)
{
     dmPerror(s);
     die();
     return (0);
}

#ifdef DMEM

void print_memstat()
{
    int i;
    
    for(i=0; i<4; i++)
        fprintf(fpstat,"--------------------");
    fprintf(fpstat,"\n");

    fprintf(fpstat,"Class\t\tbytes\tmaxbytes\telt\tmaxelt\teltsize\n");

    for(i=0; i<4; i++)
        fprintf(fpstat,"--------------------");
    fprintf(fpstat,"\n");

    fprintf(fpstat,"Dictionary:\t%d\t%d\t\t%d\t%d\t%d\n",
	dict_nbyte,
	dict_maxnbyte,
	dict_nbyte/sizeof(class dictionary),
	dict_maxnbyte/sizeof(class dictionary),
	sizeof(class dictionary));

    fprintf(fpstat,"Queue:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	queue_nbyte,
	queue_maxnbyte,
	queue_nbyte/sizeof(class queue), 
	queue_maxnbyte/sizeof(class queue),
	sizeof(class queue));

    fprintf(fpstat,"Stack:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	stack_nbyte,
	stack_maxnbyte,
	stack_nbyte/sizeof(class stack),
	stack_maxnbyte/sizeof(class stack),
	sizeof(class stack));

    fprintf(fpstat,"NtwDef:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	ntwdef_nbyte,
	ntwdef_maxnbyte,
	ntwdef_nbyte/sizeof(class ntwdef),
	ntwdef_maxnbyte/sizeof(class ntwdef),
	sizeof(class ntwdef));

    fprintf(fpstat,"NtwInst:\t%d\t%d\t\t%d\t%d\t%d\n",
	ntwinst_nbyte,
	ntwinst_maxnbyte,
	ntwinst_nbyte/sizeof(class ntwinst),
	ntwinst_maxnbyte/sizeof(class ntwinst),

	sizeof(class ntwinst));

    fprintf(fpstat,"InstStruct:\t%d\t%d\t\t%d\t%d\t%d\n",
	inst_struct_nbyte,
	inst_struct_maxnbyte,
	inst_struct_nbyte/sizeof(class instancestruct),
	inst_struct_maxnbyte/sizeof(class instancestruct),
	sizeof(class instancestruct));

    fprintf(fpstat,"NetElem:\t%d\t%d\t\t%d\t%d\t%d\n",
	netelem_nbyte,
	netelem_maxnbyte,
	netelem_nbyte/sizeof(class netelem),
	netelem_maxnbyte/sizeof(class netelem),
	sizeof(class netelem));

    fprintf(fpstat,"NetRef:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	net_ref_nbyte,
	net_ref_maxnbyte,
	net_ref_nbyte/sizeof(class net_ref),
	net_ref_maxnbyte/sizeof(class net_ref),
	sizeof(class net_ref));

    fprintf(fpstat,"Xelem:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	xelem_nbyte,
	xelem_maxnbyte,
	xelem_nbyte/sizeof(class xelem),
	xelem_maxnbyte/sizeof(class xelem),
	sizeof(class xelem));

    fprintf(fpstat,"Int:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	int_nbyte,
	int_maxnbyte,
	int_nbyte/sizeof(int),
	int_maxnbyte/sizeof(int),
	sizeof(int));

    fprintf(fpstat,"Char:\t\t%d\t%d\t\t%d\t%d\t%d\n",
	char_nbyte,
	char_maxnbyte,
	char_nbyte/sizeof(char),
	char_maxnbyte/sizeof(char),
	sizeof(char));
}
#endif
