/* SccsId = "%Z%%M% %I% (%Q%) %G%" */
/**********************************************************

Name/Version      : sls_mkdb/%I%

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.C. de Graaf
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986
Modified by       : A.J. van Genderen
Modification date : Jan-1994 (converted to c++)


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986,1994 All rights reserved
**********************************************************/

lnk::lnk (int qt)
{
	next = NULL;
	type = qt;
}

queue::queue (int qtype) : lnk (qtype)
{
	tail = 0;
	n = 0;

#ifdef DMEM
	queue_nbyte += sizeof(class queue);
	queue_maxnbyte = queue_nbyte > queue_maxnbyte ? 
                                        queue_nbyte:queue_maxnbyte;
#endif
}

queue::~queue ()
{
#ifdef DMEM
	queue_nbyte -= sizeof(class queue);
#endif
}

void queue::reset(void)
{
	n = 0;
}

short queue::length(void)
{
	return n;
}


void queue::put(class lnk *p)
{
	if(n++) {
		p->next = tail->next;
		tail->next = p;
	}
	else
		p->next = p;
	tail = p;
}

class lnk *queue::get()
{
	class lnk *p;

	if(n--) {
		p = tail->next;
		tail->next = p->next;
   		return p;
	}
	else {
		n = 0;
		return 0;
	}
}

void queue::print() {
	class lnk *cur = tail->next;
	int i = 0;

	printf("QueueB\n");
	printf("ptr: %x\tn: %d\ttail: %x\t", this, n, tail);

	if(tail)
	{
	    do {
		printf("[%d] ptr: %x\t*ptr: %x\n", i, cur, *cur);

		switch(cur -> type) {
	    	  case QueueType : printf("type: QueueType\n");
			  	((Queue *) cur)->print();
			  	break;
	    	  case NetType   : printf("type: NetType\n");
			  	((Netelem *) cur)->print();
			  	break;
	    	  case TermType   : printf("type: TermType\n");
			  	((Netelem *) cur)->print();
			  	break;
		}

		cur = cur->next;
		i++;
	    } while (cur != tail->next);
	}
	printf("QueueE\n");
}

int queue::empty(void)
{
	return (n==0);
}

class lnk *queue::access(int x)
{
	class lnk *p = tail->next;
	int i;

	for(i=0; i<x; i++)
		p = p->next;
	return p;
}

class lnk *queue::first_elem() {
	return tail->next;
}

class lnk *queue::next_elem(class lnk *cur_elem) {
	return cur_elem->next;
}

class lnk *queue::last_elem() {
	return tail;
}

void queue::append(class queue *pq)
{
	while(!pq -> empty())
	    put(pq -> get());
	delete pq;
}
