/* SccsId = "@(#)dimcheck.h 3.5 (TU-Delft) 12/04/87" */
/**********************************************************

Name/Version      : DIMCHECK/3.5

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Liedorp
Creation date     : 24-Jun-1985
Modified by       : J. Liedorp
Modification date : 04-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
*********************************************************/
#include "stdio.h"
#include "errno.h"
#include "signal.h"
#include "dmincl.h"

#define MAXGAPTABLE      8
#define MAXLINE	        80
#define MAXINT  0x3FFFFFFF

#define START_EDGE  1
#define STOP_EDGE   2
#define CHANGE_EDGE 4
#define START_CHG_EDGE START_EDGE + CHANGE_EDGE
#define STOP_CHG_EDGE  STOP_EDGE + CHANGE_EDGE
#define START_OV    8
#define STOP_OV    16

#define UP          1
#define DOWN        2

#define ON	    1
#define OFF         0

#define TRUE		0
#define FALSE		1

#define NOT_PRESENT	  0
#define CHG_TO_PRESENT	  1
#define CHG_TO_NOTPRESENT 2
#define PRESENT	 	  3

#define MAX(a,b) ((a)>(b)?(a):(b))
#define MIN(a,b) ((a)<(b)?(a):(b))
#define ABS(a)	 ((a) < 0 ? -(a) : (a))

#define EXPDATA		"exp_dat"

#define ALLOC(ptr,name) {\
if(!(ptr = (struct name *) calloc (1, sizeof (struct name))))\
perror ("calloc"); }

#define NALLOC(ptr,num,name) {\
if(!(ptr = (name *) calloc ((unsigned)(num), sizeof (name))))\
perror ("calloc"); }

#define OPEN(ptr,name,mode) {\
if(!(ptr = fopen (name, mode))) { perror (name); die (1); }}

#define CLOSE(ptr) {\
if(fclose (ptr) == EOF) { perror ("fclose"); die (1); }}

DM_STREAM *pvln[2];
FILE    *pexp;
FILE    *pdat;

char    c;
char    line[MAXLINE];

struct {
    int     e_xi;
    int     e_occ;
    int     e_yb;
    int     e_yt;
    int     e_conn;
    int     e_group;
    int     e_ctype;
}       event[2];

struct buff{
   int x;
   char edge;
   int yb;
   int yt;
   char conn;
   int grp;
   int ct;
   } *b_pntr;

struct chk_err {
    char err_type[10];
    int x1, x2, y1, y2;
    int group;
    struct chk_err *next;
} *head_err;

int     zero_flag;
int	group_check;
int     exgap;
int     exlength;
int     exgapflag;
int	gapflag;
int	widthflag;
int	maxwidthflag;
int     gap;
int     width;
int     maxwidth;
int     Errno;
int     MAXINFLUENCE;

int     nr_samples;

struct sr_field {
    int     xstart;
    int     yb;
    int     yt;
    int     lay_status;
    int     helplay_status;
    int     group;
    int     group_old;
    int     chk_type;
    int     chk_type_old;
    struct sr_field *next;
    struct sr_field *prev;
}
                   *h_sr, head_sr;

struct table {
    int     dis[MAXGAPTABLE + 1];
}
               *ptable;

double  sqrt ();
char   *strcpy ();
char   *calloc ();
