static char *SccsId = "@(#)update_sr.c 3.2 (TU-Delft) 11/16/87";
/**********************************************************

Name/Version      : DIMCHECK/3.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Liedorp
Creation date     : 24-Jun-1985
Modified by       : J. Liedorp.
Modification date : 10-Sep-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "dimcheck.h"

update_sr (x_sr, xnew)
int     xnew;			/* next state_ruler position	 */
int     x_sr;			/* state_ruler position		 */
{
/* This procedure updates the state_ruler after it has	 */
/* been analysed by extr_profile, and merges fields if	 */
/* possible.						 */

    register int    dx;
    register int    dx_prev;
    register struct sr_field   *c_sr;
    struct sr_field *rm_pntr;

/* update fields */

    dx_prev = MAXINFLUENCE;
    c_sr = h_sr -> next;
    while (c_sr != h_sr) {
	if (c_sr -> lay_status == CHG_TO_PRESENT) {
	    c_sr -> lay_status = PRESENT;
	    c_sr -> group_old = c_sr -> group;
	    c_sr -> xstart = x_sr;
	}
	else
	    if (c_sr -> lay_status == CHG_TO_NOTPRESENT) {
		c_sr -> lay_status = NOT_PRESENT;
		c_sr -> xstart = x_sr;
	    }
	c_sr -> chk_type_old = c_sr -> chk_type;
	if (c_sr -> helplay_status == CHG_TO_PRESENT)
	    c_sr -> helplay_status = PRESENT;
	if (c_sr -> helplay_status == CHG_TO_NOTPRESENT)
	    c_sr -> helplay_status = NOT_PRESENT;

/* merge fields */

	dx = MIN (xnew - c_sr -> xstart, MAXINFLUENCE);
	if ((dx_prev == dx) &&
		(c_sr -> lay_status == c_sr -> prev -> lay_status) &&
		(c_sr -> helplay_status == c_sr -> prev -> helplay_status) &&
		(c_sr -> chk_type == c_sr -> prev -> chk_type)) {
	    c_sr -> prev -> yt = c_sr -> yt;
	    rm_pntr = c_sr;
	    c_sr -> prev -> next = c_sr -> next;
	    c_sr -> next -> prev = c_sr -> prev;
	    cfree (rm_pntr);
	    c_sr = c_sr -> prev;
	}
	dx_prev = dx;
	c_sr = c_sr -> next;
    }
}
