static char *SccsId = "@(#)main.c 1.1 (TU-Delft) 08/21/85";
/**********************************************************

Name/Version      : getldm/1.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : L.K. Regenbogen 
Creation date     : 01-Jan-1985
Modified by       : S. de Graaf
Modification date : 21-Aug-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "stdio.h"

FILE   *modfile, *insort, *outsort;

char    tmpnam1[] = "/tmp/mlaXXXXXX";
char    tmpnam2[] = "/tmp/mlbXXXXXX";

char *argv0 = "getldm";		/* Program Name */
char *use_msg =			/* Command Line */
"\nUsage: %s [ofile]\n\n";

main (argc, argv)
int     argc;
char   *argv[];
{
    FILE   *openr ();
    FILE   *openw ();
    FILE   *fpo;
    char    modname[20];

    if (argc > 2) {
	fprintf (stderr, use_msg, argv0);
	exit (1);
    }

    modfile = openr ("modlist");

    fpo = stdout;
    if (argc == 2) {
	fpo = openw (argv[1]);
    }

    mktemp (tmpnam1);
    mktemp (tmpnam2);
    insort  = openw (tmpnam1);

    while (fscanf (modfile, "%s", modname) != EOF) {
	update (modname);
    }
    fclose (modfile);
    fclose (insort);

    insort  = openr (tmpnam1);
    outsort = openw (tmpnam2);
    hierar (insort, outsort);
    fclose (outsort);

    outsort = openr (tmpnam2);
    collect (outsort, fpo);
    die (0);
}

FILE *
openr (file)
char  *file;
{
    FILE *fp;
    if (!(fp = fopen (file, "r"))) {
	fprintf (stderr, "%s: cannot open file: %s\n", argv0, file);
	die (1);
    }
    return (fp);
}

FILE *
openw (file)
char  *file;
{
    FILE *fp;
    if (!(fp = fopen (file, "w"))) {
	fprintf (stderr, "%s: cannot create file: %s\n", argv0, file);
	die (1);
    }
    return (fp);
}

die (n)
int  n;
{
    unlink (tmpnam1);
    unlink (tmpnam2);
    exit (n);
}
