static char *SccsId = "@(#)update.c 1.2 (TU-Delft) 09/13/85";
/**********************************************************

Name/Version      : getldm/1.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : L.K. Regenbogen 
Creation date     : 01-Jan-1985
Modified by       : S. de Graaf
Modification date : 13-Sep-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "stdio.h"
#include "sys/types.h"
#include "sys/stat.h"

char *argv0;
struct stat file_status;

long
statf (file)
char  *file;
{
    if (stat (file, &file_status) == -1) {
	fprintf (stderr, "%s: no file: %s\n", argv0, file);
	die (1);
    }
    return (file_status.st_mtime);
}

/*
** This function looks if file "model_ldm" is younger
** than files "model_mc", "model_term" and "model_box".
** When file "model_ldm" is older, then it is created.
*/
update (model)
char   *model;
{
    FILE   *fp, *fp_ldm;
    FILE   *openr ();
    FILE   *openw ();
    long    tim_ldm;
    char    str[80];
    int     younger;

    sprintf (str, "%s/layout", model);
    if (stat (str, &file_status) == -1) {
	fprintf (stderr, "%s: no directory: %s\n", argv0, str);
	die (1);
    }

    younger = 0; /* not younger, older */

    sprintf (str, "%s/layout/%s_ldm", model, model);
    if (stat (str, &file_status) != -1) {
	/* model_ldm file does exist */
	tim_ldm = file_status.st_mtime + 10;

	sprintf (str, "%s/layout/%s_box", model, model);
	if (tim_ldm < statf (str)) goto older;

	sprintf (str, "%s/layout/%s_term", model, model);
	if (tim_ldm < statf (str)) goto older;

	sprintf (str, "%s/layout/%s_mc", model, model);
	if (tim_ldm < statf (str)) goto older;

	++younger;
    }
    else {
older:
	sprintf (str, "%s/layout/%s_ldm", model, model);
	fp_ldm = openw (str);
	fprintf (fp_ldm, "ms %s\n", model);

	/* copy term file naar ldm file */
	sprintf (str, "%s/layout/%s_term", model, model);
	fp = openr (str);
	term_copy (fp, fp_ldm);
	fclose (fp);

	/* copy box file naar ldm file */
	sprintf (str, "%s/layout/%s_box", model, model);
	fp = openr (str);
	box_copy (fp, fp_ldm);
	fclose (fp);
    }

    /* copy "_mc" file to "_ldm" file and make sort-file */
    sprintf (str, "%s/layout/%s_mc", model, model);
    fp = openr (str);
    mc_copy (fp, fp_ldm, model, younger);
    fclose (fp);
    if (!younger) {
	fprintf (fp_ldm, "me\n");
	fclose (fp_ldm);
    }
}

term_copy (fp, fp_ldm)
FILE  *fp, *fp_ldm;
{
    int     box[4];
    int     dx, nx, dy, ny;
    char    name[20];
    char    mask[6];

    while (fscanf (fp, "%s%d%d%d%d%s%d%d%d%d", name, &box[0], &box[1], &box[2],
		&box[3], mask, &dx, &nx, &dy, &ny) != EOF) {

	fprintf (fp_ldm, "term %s %d %d %d %d %s", &mask[2],
		box[0], box[1], box[2], box[3], name);
	if (nx > 0)
	    fprintf (fp_ldm, " cx %d %d", dx, nx);
	if (ny > 0)
	    fprintf (fp_ldm, " cy %d %d", dy, ny);
	fprintf (fp_ldm, "\n");
    }
}

box_copy (fp, fp_ldm)
FILE  *fp, *fp_ldm;
{
    int     box[4];
    int     dx, nx, dy, ny;
    char    mask[6];

    while (fscanf (fp, "%*d%*d%*d%*d%s%d%d%d%d%d%d%d%d", mask, &box[0], &box[1],
		&box[2], &box[3], &dx, &nx, &dy, &ny) != EOF) {

	fprintf (fp_ldm, "box %s %d %d %d %d", mask,
			box[0], box[1], box[2], box[3]);
	if (nx > 0)
	    fprintf (fp_ldm, " cx %d %d", dx, nx);
	if (ny > 0)
	    fprintf (fp_ldm, " cy %d %d", dy, ny);
	fprintf (fp_ldm, "\n");
    }
}

mc_copy (fp, fp_ldm, model, younger)
FILE  *fp, *fp_ldm;
char   *model, younger;
{
    int     mirror, rot, tx, ty, sx, sy, dx, nx, dy, ny;
    char    inst_name[20], name[20];
    extern  FILE *insort;

    fprintf (insort, "%s %s\n", model, model);

    while (fscanf (fp, "%s%*d%*d%*d%*d%s%d%d%d%d%d%d%d%d%d%d",
	    inst_name, name, &mirror, &rot, &tx, &ty, &sx, &sy,
	    &dx, &nx, &dy, &ny) != EOF) {

	if (!younger) {
	    if (!strcmp (inst_name, "."))
		fprintf (fp_ldm, "mc %s", name);
	    else
		fprintf (fp_ldm, "mc <%s> %s", inst_name, name);

	    switch (mirror) {
		case 1: 
		    fprintf (fp_ldm, " mx");
		    break;
		case -1: 
		    fprintf (fp_ldm, " my");
		    break;
	    }
	    switch (rot) {
		case 90: 
		    fprintf (fp_ldm, " r3");
		    break;
		case 180: 
		    fprintf (fp_ldm, " r6");
		    break;
		case 270: 
		    fprintf (fp_ldm, " r9");
		    break;
	    }
	    if (tx || ty)
		fprintf (fp_ldm, " %d %d", tx, ty);
	    if (nx > 0)
		fprintf (fp_ldm, " cx %d %d", dx, nx);
	    if (ny > 0)
		fprintf (fp_ldm, " cy %d %d", dy, ny);
	    fprintf (fp_ldm, "\n");
	}
	fprintf (insort, "%s %s\n", name, model);
    }
}
